/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ObjectContainerDialog;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.exception.ReadOnlyException;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.ui.msg.ProjectUiMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.FuegoJob;
import oracle.bpm.ui.FuegoWorker;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;

public class CustomizeTypeAction
extends DesignerAction {
    private BpmObject bpmObject;
    static final long serialVersionUID = -813426404642634611L;
    static final long serialCheck = 6911462375164798835L;

    public CustomizeTypeAction() {
        super(DesignerMsg.CUSTOMIZE_TYPE);
        this.requires(BpmObject.class);
    }

    @Override
    public boolean doIt() {
        this.bpmObject = (BpmObject)this.getSelection().as(BpmObject.class);
        return this.newBpmObject();
    }

    public void unDoIt() {
    }

    private boolean createBpmObject(final CatalogModule parent, final String name, final CatalogObject schema) {
        CatalogObject newType = (CatalogObject)FuegoWorker.post((FuegoJob)new FuegoJob<CatalogObject>(){

            public CatalogObject run() {
                try {
                    BpmObject result = schema != null ? parent.newBpmObjectFromSchema(name, schema) : parent.newBpmObject(name);
                    return result;
                }
                catch (ProjectException e) {
                    return null;
                }
            }
        });
        try {
            parent.asMutable().addChild((ProjectObject)newType);
            OpenObjectAction oca = new OpenObjectAction(newType);
            oca.runWithSelection(newType);
            return oca.isSuccess();
        }
        catch (ReadOnlyException e) {
            MessageDialog.showError((Msg)e.getMsg());
            return false;
        }
        catch (ProjectException e) {
            MessageDialog.showError((Msg)e.getMsg());
            return false;
        }
    }

    private boolean newBpmObject() {
        ObjectContainerDialog dialog = new ObjectContainerDialog(Ui.getRoot(), ProjectUiMsg.CREATE((Msg)BpmObjectMsg.BPM_OBJECT), BpmObjectMsg.BPM_OBJECT, "BusinessObject", this.bpmObject.getProject(), this.bpmObject);
        dialog.setVisible(true);
        if (dialog.userAccepted()) {
            CatalogModule parent = dialog.getParentModule();
            String name = dialog.getObjectName();
            CatalogObject schema = dialog.getExternalSchema();
            return this.createBpmObject(parent, name, schema);
        }
        return false;
    }
}

