/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.Iterator;
import java.util.List;
import oracle.bpm.dashboard.model.WidgetDataModel;
import oracle.bpm.dashboard.model.WidgetModel;
import oracle.bpm.dashboard.model.WidgetPresentationModel;
import oracle.bpm.dashboard.model.WidgetType;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.dashboardwizards.WizardPreferencesPanel;
import oracle.bpm.designer.dashboardwizards.configurationpanels.WidgetDisplayPreferencesBuilder;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.dashboard.WidgetDataModelImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.dashboard.WidgetModel;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiWindow;

public class CreateWidgetAction
extends DesignerAction {
    private boolean frame;
    private WidgetModel.Mutable newWidget;
    private Dialog parentDialog;
    private Frame parentFrame;
    private FuegoProject project;
    static final long serialVersionUID = -6158760497755487653L;
    static final long serialCheck = -297984097911762549L;

    public CreateWidgetAction(FuegoProject project) {
        super(DesignerMsg.CREATE_WIDGET);
        this.project = project;
    }

    public oracle.bpm.dashboard.model.WidgetModel getNewWidget() {
        return this.newWidget;
    }

    public void setParentDialog(Dialog parentDialog) {
        this.parentDialog = parentDialog;
        this.frame = false;
    }

    public void setParentFrame(Frame parentFrame) {
        this.parentFrame = parentFrame;
        this.frame = true;
    }

    @Override
    public boolean doIt() {
        this.newWidget = (WidgetModel.Mutable)this.project.createWidget().asMutable();
        this.newWidget.setName(this.getDefaultName());
        String name = this.getDefaultName();
        WidgetPresentationModel.Mutable defaultPresentationModel = WidgetDisplayPreferencesBuilder.createDefaultPresentationModel((Project)this.project).asMutable();
        defaultPresentationModel.setName(name);
        defaultPresentationModel.setTitle(name);
        this.newWidget.setPresentationModel((WidgetPresentationModel)defaultPresentationModel);
        WidgetDataModelImpl dataModel = new WidgetDataModelImpl((Project)this.project);
        dataModel.setType(WidgetType.ACTIVITY_WORKLOAD);
        this.newWidget.setDataModel((WidgetDataModel)dataModel);
        WizardPreferencesPanel widgetPreferencesPanel = new WidgetDisplayPreferencesBuilder().build(null, (oracle.bpm.dashboard.model.WidgetModel)this.newWidget);
        CreateWidgetOkCancelDialog dialog = this.frame ? new CreateWidgetOkCancelDialog(this.parentFrame, DesignerMsg.CREATE_WIDGET) : new CreateWidgetOkCancelDialog(this.parentDialog, DesignerMsg.CREATE_WIDGET);
        boolean result = OkCancelDialog.doShowDialog((OkCancelDialog)dialog, (UiComponent)widgetPreferencesPanel);
        this.newWidget.setName(this.newWidget.getPresentationModel().getName());
        return result;
    }

    public void unDoIt() {
    }

    private String getDefaultName() {
        String result = "";
        List widgets = this.project.getWidgetsList();
        int counter = 1;
        result = "Widget" + counter;
        while (((WidgetModel)widgets.get(counter)).getName().equals(result)) {
            result = "Widget" + ++counter;
        }
        return result;
    }

    private boolean exists(oracle.bpm.dashboard.model.WidgetModel widget) {
        List widgets = this.project.getWidgetsList();
        boolean exists = false;
        Iterator iterator = widgets.iterator();
        while (!exists && iterator.hasNext()) {
            WidgetModel widgetModel = (WidgetModel)iterator.next();
            exists = widgetModel.getName().equals(widget.getName());
        }
        return exists;
    }

    class CreateWidgetOkCancelDialog
    extends OkCancelDialog {
        public CreateWidgetOkCancelDialog(Dialog owner, Msg msg) {
            super((UiWindow)owner, msg, true);
        }

        public CreateWidgetOkCancelDialog(Frame owner, Msg msg) {
            super((UiWindow)owner, msg, true);
        }

        public void ok() {
            if (CreateWidgetAction.this.exists((oracle.bpm.dashboard.model.WidgetModel)CreateWidgetAction.this.newWidget)) {
                MessageDialog.showError((Msg)DesignerMsg.WIDGET_NAME_ALREADY_EXISTS);
            } else {
                this.close();
            }
        }
    }
}

