/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import oracle.bpm.connector.ConnectorException;
import oracle.bpm.connector.ConnectorService;
import oracle.bpm.connector.ConnectorTransaction;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.Environment;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.log.Log;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.sql.struct.SchemaUtils;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.filechooser.FileChooser;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.util.FileFilter;

public class CreateSchemaAction
extends DesignerAction {
    private final CatalogObject catalogObject;
    private static final String SQL_EXT = ".sql";
    static final long serialVersionUID = 2113063733572214791L;
    static final long serialCheck = 6241202578391705342L;

    public CreateSchemaAction(CatalogObject object) {
        super(DesignerMsg.CREATE_SCHEMA);
        this.catalogObject = object;
        this.requires(ObjectTypeDescription.class);
        this.requires(CatalogObject.class);
        this.setShowOnDisabled(false);
    }

    @Override
    public void run() {
        File file = this.getFile();
        if (file != null) {
            this.setupConnectorService(this.getProject());
            this.doStore(file);
        }
    }

    protected void updateEnableStatus(Selection selection) {
        ObjectTypeDescription objectType = (ObjectTypeDescription)selection.as(ObjectTypeDescription.class);
        this.setEnabled(objectType.isSql() && "true".equals(objectType.getProperty("isSchema")));
    }

    private Project getProject() {
        return this.catalogObject.getProject();
    }

    private void setupConnectorService(Project project) {
        if (ConnectorTransaction.isStarted()) {
            try {
                ConnectorTransaction.current().rollback();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        Environment environment = AbstractStudioWorkbench.getEnvironment();
        ConnectorService connectorService = ((FuegoProject)project).getConnectorService(environment);
        ConnectorTransaction.setConnectorService(connectorService);
    }

    private File getFile() {
        int res;
        File selectedFile;
        FileChooser chooser = new FileChooser();
        chooser.setName("create.schema");
        FileFilter filter = FileFilter.create(UIMsg.TYPE_FILES((String)"SQL"), SQL_EXT);
        chooser.setFileFilter(filter);
        chooser.setSelectedFile(new File(chooser.getCurrentDirectory() + File.separator + this.catalogObject.getName() + SQL_EXT));
        boolean accepted = chooser.showSaveDialog((UiComponent)Ui.getRoot()) == 0;
        File file = selectedFile = accepted ? chooser.getSelectedFile() : null;
        if (selectedFile != null && selectedFile.exists() && (res = MessageDialog.showQuestion((UiContainer)null, (Msg)UIMsg.WARNING, (Msg)DesignerMsg.FILE_EXISTS_SAVE_ANYWAY, null, (int)9, null)) != 1) {
            selectedFile = null;
        }
        return selectedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doStore(File selectedFile) {
        ObjectTypeDescription objectType = this.catalogObject.getObjectType();
        String schema = null;
        try {
            schema = SchemaUtils.createSchema(objectType);
        }
        catch (ConnectorException e) {
            MessageDialog.showError((Msg)DesignerMsg.CREATE_SCHEMA, (Msg)DesignerMsg.ERROR, (Throwable)e);
        }
        catch (SQLException e) {
            MessageDialog.showError((Msg)DesignerMsg.CREATE_SCHEMA, (Msg)DesignerMsg.ERROR, (Throwable)e);
        }
        boolean successfull = false;
        if (schema != null) {
            FileWriter writer = null;
            try {
                writer = new FileWriter(selectedFile);
                writer.write(schema);
                writer.flush();
            }
            catch (IOException e) {
                Log.logSevere(e);
                successfull = false;
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        Log.logSevere(e);
                        successfull = false;
                    }
                }
            }
        }
        return successfull;
    }
}

