/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import java.util.List;
import oracle.bpm.dashboard.model.DashboardModel;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.AddObjectTypeDescriptionAction;
import oracle.bpm.designer.action.DeleteActionFactory;
import oracle.bpm.designer.action.DeleteObjectAction;
import oracle.bpm.designer.action.ModuleAction;
import oracle.bpm.designer.action.OpenObjectPresentationAction;
import oracle.bpm.designer.dashboard.generation.DashboardFactory;
import oracle.bpm.designer.dashboardwizards.DashboardWizard;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.CatalogModule;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Dialog;
import oracle.bpm.ui.IdentifierTextField;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class CreateDashboardAction
extends ModuleAction {
    private Dialog dialog;
    private CatalogObject parentType;
    private Project project;
    public static final String NEW_DASHBOARD = "NewDashboard";
    static final long serialVersionUID = 1705564696451439614L;
    static final long serialCheck = -3113426503522121880L;

    public CreateDashboardAction(CatalogModule module) {
        super(DesignerMsg.CREATE_DASHBOARD);
        this.parentType = module;
        this.setExcludeDefault(true);
        this.setExcludeRoot(true);
        this.setShowOnDisabled(false);
        this.project = module.getProject();
    }

    public static RenameDialog showRenameDialog(CatalogObject existingObject, UiWindow parent, String name) {
        RenameDialog renameDialog = new RenameDialog(existingObject, parent, name);
        renameDialog.pack();
        renameDialog.setLocationRelativeTo((UiComponent)parent);
        renameDialog.setVisible(true);
        return renameDialog;
    }

    @Override
    public boolean doIt() {
        DashboardModel dashboardModel;
        DashboardWizard dashboardWizard = new DashboardWizard(this.parentType);
        this.dialog = dashboardWizard.getCreationDialog(this.parentType);
        this.dialog.setVisible(true);
        boolean accepted = this.dialog.userAccepted();
        if (accepted && (dashboardModel = dashboardWizard.getDashboardModel()) != null) {
            this.createCustomDashboard(dashboardModel, this.parentType);
        }
        return accepted;
    }

    public XObjectTypeDescription createDashboard(DashboardModel dashboardModel, CatalogObject parent) {
        return this.createDashboard(dashboardModel, parent, dashboardModel.getName());
    }

    public XObjectTypeDescription createDashboard(DashboardModel dashboardModel, CatalogObject parent, String name) {
        ComponentCatalog catalogRepository = this.project.getComponentCatalog();
        List<XObjectTypeDescription> dashes = new DashboardFactory().createDashboard(dashboardModel, catalogRepository, name);
        for (XObjectTypeDescription dash : dashes) {
            XObjectTypeDescription dashTypeDescription = dash;
            if (parent.findInnerType(dashTypeDescription.getName()) != null) continue;
            new AddObjectTypeDescriptionAction(parent, CatalogObjectImpl.create((TypeRef)dashTypeDescription)).doIt();
            XFormPresentationModel presentation = dashTypeDescription.getPresentationModel(dashTypeDescription.getDefaultPresentationName());
            new OpenObjectPresentationAction(presentation, dashTypeDescription).doIt();
        }
        return !dashes.isEmpty() ? dashes.get(dashes.size() - 1) : null;
    }

    public void createCustomDashboard(DashboardModel dashboardModel, CatalogObject parent) {
        String name = dashboardModel.getName();
        CatalogObject type = parent.findInnerType(dashboardModel.getName());
        if (type != null) {
            RenameDialog renameDialog = CreateDashboardAction.showRenameDialog(type, Ui.getRoot(), name);
            if (renameDialog.createDashboard()) {
                this.createDashboard(dashboardModel, parent, renameDialog.getName());
            }
        } else {
            this.createDashboard(dashboardModel, parent, name);
        }
    }

    public void unDoIt() {
    }

    public static class RenameDialog
    extends OkCancelDialog {
        private boolean createDashboard;
        private String name;
        private IdentifierTextField nameTextField;

        public RenameDialog(CatalogObject existingObject, UiWindow parent, String originalName) {
            super(parent, DesignerMsg.CHOOSE_NAME, true);
            this.name = originalName;
            Panel panel = this.createPanel();
            this.getContentPane().add((UiComponent)panel, (Object)"Center");
            this.addAditionalButton(new Button[]{new Button(this.getAditionalButtonsAddPoint(), (BaseAction)new OverwriteDashboardAction(existingObject))});
        }

        public void ok() {
            this.name = this.nameTextField.getText();
            this.createDashboard = true;
            this.close();
        }

        public void cancel() {
            this.createDashboard = false;
            super.cancel();
        }

        public String getName() {
            return this.name;
        }

        public boolean createDashboard() {
            return this.createDashboard;
        }

        private Panel createPanel() {
            Panel panel = new Panel(this.getContentPane());
            String columns = "5dlu, pref, 5dlu, 150dlu, 5dlu";
            String rows = "5dlu, pref, 5dlu, pref, 25dlu";
            FormLayout layout = new FormLayout(columns, rows);
            CellConstraints cc = new CellConstraints();
            panel.setLayout((Layout)layout);
            panel.add((UiComponent)new LabelMultiline((UiContainer)panel, DesignerMsg.DASHBOARD_ALREADY_EXISTS(this.name)), (Object)cc.xywh(2, 2, 3, 1));
            this.nameTextField = new IdentifierTextField((UiContainer)panel, "", true, true);
            panel.add((UiComponent)Label.create((UiContainer)panel, (Msg)DesignerMsg.NAME), (Object)cc.xy(2, 4));
            panel.add((UiComponent)this.nameTextField, (Object)cc.xy(4, 4));
            return panel;
        }

        public class OverwriteDashboardAction
        extends DesignerAction {
            private CatalogObject objectToDelete;

            public OverwriteDashboardAction(CatalogObject existingObject) {
                super(DesignerMsg.OVERWRITE);
                this.objectToDelete = existingObject;
            }

            @Override
            public boolean doIt() {
                DeleteObjectAction deleteCatalogNodeAction = DeleteActionFactory.getDeleteActionFor((ProjectObject)this.objectToDelete);
                boolean result = deleteCatalogNodeAction.doIt();
                RenameDialog.this.createDashboard = true;
                RenameDialog.this.close();
                return result;
            }

            public void unDoIt() {
            }
        }
    }
}

