/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.OpenObjectPresentationAction;
import oracle.bpm.designer.action.PresentationNameValidator;
import oracle.bpm.designer.catalog.tree.ObjectPresentationTreeNode;
import oracle.bpm.designer.formdesigner.preferences.PresentationPreferencesPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeCatalogException;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.pref.Category;
import oracle.bpm.ui.pref.PreferencesDialog;
import oracle.bpm.xobject.presentationmodel.PresentationGenerationOptions;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class CopyPresentationAction
extends DesignerAction {
    private String name;
    private ObjectPresentationTreeNode presentation;
    private XObjectTypeDescription xotd;
    static final long serialVersionUID = 1413429711514678863L;
    static final long serialCheck = -846858524533406019L;

    public CopyPresentationAction(ObjectPresentationTreeNode presentation, XObjectTypeDescription xotd) {
        super(UIMsg.COPY);
        this.requires(XFormPresentationModel.class);
        this.presentation = presentation;
        this.xotd = xotd;
    }

    public CopyPresentationAction(ObjectPresentationTreeNode presentation, XObjectTypeDescription xotd, String name) {
        this(presentation, xotd);
        this.name = name;
    }

    @Override
    public boolean doIt() {
        return this.copyPresentation();
    }

    public void unDoIt() {
    }

    boolean copy() {
        try {
            MutableComponentCatalog repository = (MutableComponentCatalog)this.xotd.getCatalog();
            repository.update(this.xotd);
            new OpenObjectPresentationAction(this.copy(this.name), this.xotd).doIt();
            return true;
        }
        catch (TypeCatalogException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        catch (Exception e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
    }

    XFormPresentationModel copy(String name) {
        XFormPresentationModel pModel = this.presentation.getPresentationModel();
        PresentationGenerationOptions.load();
        XFormPresentationModel presentationModel = pModel.clone();
        presentationModel.setPresentationName(name);
        this.xotd.setPModel(presentationModel, name);
        presentationModel.setOwner(this.xotd);
        return presentationModel;
    }

    private String getDefaultName() {
        String name;
        int counter = 1;
        do {
            name = "Presentation" + counter++;
        } while (this.xotd.getPresentations().containsKey(name));
        return name;
    }

    private boolean copyPresentation() {
        return this.promptForNewName() && this.copy();
    }

    private boolean promptForNewName() {
        this.name = MessageDialog.showInputDialog((UiWindow)Ui.getRoot(), (Msg)UIMsg.COPY, (Msg)DesignerMsg.PRESENTATION_NAME, (InputValidator)((Object)new PresentationNameValidator(this.xotd)), (String)this.getDefaultName(), (boolean)true, (boolean)true);
        return this.name != null;
    }

    public static class PreferencesAction
    extends BaseAction {
        PresentationGenerationOptions options;
        UiComponent parentComponent;

        public PreferencesAction() {
            this(PresentationGenerationOptions.load());
        }

        public PreferencesAction(PresentationGenerationOptions options) {
            super(DesignerMsg.PRESENTATION_PREFERENCES);
            this.options = options;
        }

        public void setParentComponent(UiComponent c) {
            this.parentComponent = c;
        }

        public void run() {
            PreferencesDialog preferencesDialog = new PreferencesDialog(Ui.getRoot(), DesignerMsg.PRESENTATION_PREFERENCES, true);
            for (Category aC : new PresentationPreferencesPanel((UiContainer)preferencesDialog, this.options).getCategories()) {
                preferencesDialog.addCategory(aC);
            }
            preferencesDialog.pack();
            preferencesDialog.setLocationRelativeTo(this.parentComponent);
            preferencesDialog.setVisible(true);
        }
    }
}

