/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import javax.swing.Action;
import oracle.bpm.designer.DesignerActions;
import oracle.bpm.designer.action.ActionSet;
import oracle.bpm.designer.action.BaseActionSet;
import oracle.bpm.designer.action.ComponentActions;
import oracle.bpm.designer.action.MethodsListAction;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.RepositoryService;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.selection.Selection;

public class ComponentActionSet
extends BaseActionSet
implements ActionSet {
    private static ComponentActionSet instance = new ComponentActionSet();

    private ComponentActionSet() {
    }

    public static ComponentActionSet get() {
        return instance;
    }

    @Override
    public ActionGroup getDefaultMenuActions(Object arg) {
        if (arg == null) {
            throw new IllegalArgumentException("TypeDescription argument cannot be null");
        }
        if (!(arg instanceof ObjectTypeDescription)) {
            return null;
        }
        return this.getActions((ObjectTypeDescription)arg);
    }

    @Override
    public ActionGroup getViewMenuActions(Object arg) {
        return null;
    }

    @Override
    public void updateSharedActions(Object arg) {
    }

    public ActionGroup getActions(Selection selection) {
        ObjectTypeDescription objectType = (ObjectTypeDescription)selection.as(ObjectTypeDescription.class);
        return objectType != null ? this.getActions(objectType) : new ActionGroup(null);
    }

    public ActionGroup getActions(ObjectTypeDescription objectType) {
        FuegoProject project = FuegoProject.getFrom((TypeRef)objectType);
        if (project == null && !TypeUtils.belongsToDefaultCatalog(objectType)) {
            Platform.getInternalReportingService().reportIssue("Component has no project", "Component " + objectType);
            project = (FuegoProject)RepositoryService.getInstance().getActiveRepository().getDefaultProject();
        }
        return new ComponentActions((Project)project, CatalogObjectImpl.create((Project)project, (TypeRef)objectType)).getActions();
    }

    public String getComponentType(TypeRef ref) {
        TypeInfo info = this.getTypeInfo(ref);
        String componentType = null;
        if (info != null) {
            componentType = info.getType();
        }
        componentType = componentType != null ? componentType : "object";
        return componentType;
    }

    @Override
    public void updateSharedMenus(Object arg) {
        if (arg == null) {
            BaseActionSet.disableAction((Action)((Object)DesignerActions.previousMemberAction));
            BaseActionSet.disableAction((Action)((Object)DesignerActions.nextMemberAction));
            BaseActionSet.disableAction((Action)((Object)DesignerActions.methodListAction));
        } else {
            assert (arg instanceof ObjectTypeDescription) : "Invalid argument; must be ObjectTypeDescription, but it is: " + arg.getClass();
            ObjectTypeDescription objectType = (ObjectTypeDescription)arg;
            BaseActionSet.ActionsMap actions = this.getSharedActions();
            MethodsListAction methodListAction = (MethodsListAction)actions.get("component-show-methods-list");
            methodListAction.setObjectType(objectType);
            BaseActionSet.enableAction(DesignerActions.previousMemberAction, actions.get("component-select-previous-method"));
            BaseActionSet.enableAction(DesignerActions.nextMemberAction, actions.get("component-select-next-method"));
            BaseActionSet.enableAction(DesignerActions.methodListAction, methodListAction);
        }
    }

    @Override
    protected void registerSharedActions(BaseActionSet.ActionsMap actionsMap) {
        super.registerSharedActions(actionsMap);
        actionsMap.put("component-show-methods-list", new MethodsListAction());
    }

    private TypeInfo getTypeInfo(TypeRef ref) {
        MutableComponentCatalog catalog = (MutableComponentCatalog)ref.getCatalog();
        return catalog == null ? null : catalog.getInfo(ref);
    }
}

