/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.OpenEditorAction;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class CloseObjectPresentationNodeAction
extends OpenEditorAction {
    private final CatalogObject parentCatalogObject;
    private final XFormPresentationModel presentationModel;
    static final long serialVersionUID = 3332815583078967620L;
    static final long serialCheck = 4685181973908651509L;

    public CloseObjectPresentationNodeAction(XFormPresentationModel presentationModel, CatalogObject parentCatalogObject) {
        super(UIMsg.CLOSE);
        this.requires(XFormPresentationModel.class);
        this.requires(FlowNode.class);
        this.presentationModel = presentationModel;
        this.parentCatalogObject = parentCatalogObject;
    }

    @Override
    public void run() {
        BPMObjectEditor bpmObjectEditor = this.getBPMObjectEditor();
        if (bpmObjectEditor != null) {
            bpmObjectEditor.closePresentation(this.presentationModel);
        }
    }

    public boolean isOpened() {
        BPMObjectEditor bpmObjectEditor = this.getBPMObjectEditor();
        return bpmObjectEditor != null && bpmObjectEditor.isEditorOpenedFor(this.presentationModel);
    }

    private BPMObjectEditor getBPMObjectEditor() {
        return (BPMObjectEditor)this.getWorkbench().findEditorByObject(this.parentCatalogObject);
    }
}

