/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.xobject.presentationmodel.XFormPresentationModel;

public class CloseBPMObjectPresentationAction
extends DesignerAction {
    private XFormPresentationModel presentation;

    public CloseBPMObjectPresentationAction(XFormPresentationModel presentation) {
        super(UIMsg.CLOSE);
        this.requires(AttributeTypeDescription.class);
        this.presentation = presentation;
    }

    @Override
    public boolean doIt() {
        boolean result = false;
        StudioEditor editor = AbstractStudioWorkbench.getInstance().findEditorByObject(this.getCatalogObject());
        if (editor != null) {
            ((BPMObjectEditor)editor).closePresentation(this.presentation);
            result = true;
        }
        return result;
    }

    public boolean isOpened() {
        boolean result = false;
        StudioEditor editor = AbstractStudioWorkbench.getInstance().findEditorByObject(this.getCatalogObject());
        if (editor != null) {
            result = ((BPMObjectEditor)editor).isEditorOpenedFor(this.presentation);
        }
        return result;
    }

    public void unDoIt() {
    }

    private CatalogObject getCatalogObject() {
        return CatalogObjectImpl.create((TypeRef)this.presentation.getOwner());
    }
}

