/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.command.design.ChangeTargetForNoteCommand;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.TextAnnotation;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTargetForNoteAction
extends DesignerAction {
    @Nullable
    private FlowNode newTarget;

    public ChangeTargetForNoteAction() {
        super(DesignerMsg.NONE);
        this.requires(TextAnnotation.class);
        this.newTarget = null;
    }

    public ChangeTargetForNoteAction(@NotNull FlowNode newTarget) {
        super(Msg.QUOTE(newTarget.getDefaultLabel()));
        this.setSmallIcon(DefaultTheme.getDefault().getImageFor((FlowElement)newTarget, ImageType.ICON));
        this.requires(TextAnnotation.class);
        this.newTarget = newTarget;
    }

    @Override
    public void run() {
        this.getRunner().run((Command)new ChangeTargetForNoteCommand(this.getModelNote(), this.newTarget));
    }

    private TextAnnotation getModelNote() {
        return (TextAnnotation)this.getSelection().as(TextAnnotation.class);
    }
}

