/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.AddAttributeAccessorAction;
import oracle.bpm.designer.action.RemoveAttributeAccessorAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;

public class ChangeAttributeVirtualAction
extends DesignerAction {
    private AttributeTypeDescription attribute;
    private boolean value;

    public ChangeAttributeVirtualAction(AttributeTypeDescription attributeTypeDescription, boolean value) {
        super(value ? DesignerMsg.MAKE_VIRTUAL : DesignerMsg.MAKE_NON_VIRTUAL);
        this.attribute = attributeTypeDescription;
        this.value = value;
    }

    public AttributeTypeDescription getAttribute() {
        return this.attribute;
    }

    @Override
    public void run() {
        String defaultValue = this.attribute.getDefaultValue();
        this.attribute.setDefaultValue(null);
        if (this.value) {
            if (!this.hasReadAccessMethod()) {
                new AddAttributeAccessorAction(this.attribute, 8).doIt();
            }
            if (!this.hasWriteAccessMethod()) {
                new AddAttributeAccessorAction(this.attribute, 7).doIt();
            }
        } else if (this.confirmAccessorsDeletion()) {
            new RemoveAttributeAccessorAction(this.attribute, 8).doIt();
            new RemoveAttributeAccessorAction(this.attribute, 7).doIt();
        }
        this.attribute.setVirtual(this.value);
        boolean warnModifiers = this.checkVirtual();
        boolean rollback = false;
        if (warnModifiers) {
            rollback = this.askForRollback();
        }
        if (rollback) {
            this.attribute.setVirtual(!this.value);
            this.attribute.setDefaultValue(defaultValue);
            this.checkVirtual();
        }
    }

    private boolean hasWriteAccessMethod() {
        return Modifier.hasSetter(this.getAttribute().getModifiers()) && this.getAttribute().asAttribute().getWriteCode() != null;
    }

    private boolean hasReadAccessMethod() {
        return this.getAttribute().hasGetter() && this.getAttribute().asAttribute().getCode() != null;
    }

    private boolean askForRollback() {
        return false;
    }

    private boolean confirmAccessorsDeletion() {
        int value = MessageDialog.showQuestion((Msg)CoreMsg.WARNING, (Msg)DesignerMsg.REMOVE_ACCESSORS, (int)6);
        return value == 2;
    }

    private boolean checkVirtual() {
        boolean warnModifiers = false;
        if (this.attribute.isVirtual()) {
            long modifiers;
            if (Modifier.hasGetter(this.attribute.getModifiers()) && this.attribute.getCode() == null) {
                this.attribute.clearModifier(8L);
            }
            if (Modifier.hasSetter(this.attribute.getModifiers()) && this.attribute.getWriteCode() == null) {
                this.attribute.clearModifier(4L);
            }
            if (!Modifier.hasGetter(modifiers = this.attribute.getModifiers()) && !Modifier.hasGetter(modifiers)) {
                warnModifiers = true;
            }
        } else {
            this.attribute.addModifiers(4L);
            this.attribute.addModifiers(8L);
        }
        return warnModifiers;
    }
}

