/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.catalog.tree.ObjectAttributeMemberTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.DialogFactory;
import oracle.bpm.ui.HiddenMessagesPreferences;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.xobject.lib.ConstructionException;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class ChangeAttributeProfile
extends DesignerAction {
    private ObjectAttributeMemberTreeNode attrNode;

    public ChangeAttributeProfile(ObjectAttributeMemberTreeNode attrNode) {
        super(DesignerMsg.CHANGE_ATTR_PROFILE);
        this.attrNode = attrNode;
    }

    @Override
    public boolean doIt() {
        return this.changeAttribute();
    }

    public void unDoIt() {
    }

    private boolean changeAttribute() {
        AttributeTypeDescription newAttr;
        DesignerPreferences preferences = DesignerPreferences.getPreferences();
        boolean result = DialogFactory.showConfirmDialog((HiddenMessagesPreferences)preferences, (Msg)DesignerMsg.CHANGE_ATTR_PROFILE, (Msg)DesignerMsg.CONFIRM_CHANGE_ATTRIBUTE);
        if (!result) {
            return false;
        }
        MethodTypeDescription member = this.attrNode.getMember();
        try {
            newAttr = XObjectTypeDescriptionHelper.changeAttributeProfile((MethodTypeDescription)member);
        }
        catch (ConstructionException e) {
            MessageDialog.showError((Throwable)e);
            return false;
        }
        OpenCloseMemberAction.openMember(newAttr);
        return true;
    }
}

