/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.collections.Function;
import oracle.bpm.command.Command;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesDialog;
import oracle.bpm.designer.flowpanels.FlowNodePropertiesPreferences;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.command.design.ChangeActivityTypeCommand;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.FlowNode;
import org.jetbrains.annotations.NotNull;

public final class ChangeActivityTypeAction
extends DesignerAction {
    private final BpmnType type;

    public ChangeActivityTypeAction(@NotNull BpmnType type) {
        super(type.getLabel());
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        this.setSmallIcon(theme.getImageFor(FlowFigureUtils.fromType((BpmnType)type), ImageType.ICON));
        this.requires(Activity.class);
        this.type = type;
    }

    @Override
    public void run() {
        FlowNodePropertiesPreferences preferences = FlowNodePropertiesPreferences.create();
        preferences.addAfterCopyFunction(new MutateActivityFunction(this.type));
        preferences.setSelectedSheet(FlowNodePropertiesPreferences.SHOW_IMPLEMENTATION);
        FlowNodePropertiesDialog.editProperties((FlowNode)this.getActivity(), preferences);
    }

    private Activity getActivity() {
        return (Activity)this.getSelection().as(Activity.class);
    }

    private static final class MutateActivityFunction
    implements Function<FlowNode, FlowNode> {
        private final BpmnType type;

        public MutateActivityFunction(@NotNull BpmnType type) {
            this.type = type;
        }

        @Override
        public FlowNode eval(@NotNull FlowNode value) {
            Activity activity = (Activity)value.asAnyNode(Activity.class);
            if (activity != null) {
                ActionRunner.getInstance().run((Command)new ChangeActivityTypeCommand(activity, this.type));
            }
            return activity;
        }
    }
}

