/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.figure.FlowFigureUtils;
import oracle.bpm.draw.themes.DefaultTheme;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.project.command.design.BoundEventCommand;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.Event;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import org.jetbrains.annotations.NotNull;

public class BoundEventToAction
extends DesignerAction {
    private final Activity activity;

    public BoundEventToAction(@NotNull Activity activity) {
        this(activity, Msg.QUOTE(ModelUtils.getDuplicatedLabel((FlowNode)activity)));
        DefaultTheme theme = DesignerPreferences.getPreferences().getTheme();
        this.setSmallIcon(theme.getImageFor(FlowFigureUtils.fromType((BpmnType)activity.getBpmnType()), ImageType.ICON));
    }

    public BoundEventToAction(@NotNull Activity activity, @NotNull Msg msg) {
        super(msg);
        this.activity = activity;
        this.requires(Event.class);
    }

    @Override
    public void run() {
        this.getRunner().run((Command)new BoundEventCommand(this.getEvent(), this.activity));
    }

    private Event getEvent() {
        return (Event)this.getSelection().as(Event.class);
    }
}

