/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.action.BPMObjectAttributeInputValidator;
import oracle.bpm.designer.action.NewMethodAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.util.Identifier;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class BPMObjectMethodInputValidator
implements InputValidator {
    private ObjectTypeDescription object;

    public BPMObjectMethodInputValidator(ObjectTypeDescription object) {
        this.object = object;
    }

    public static void validateName(String name) throws InputValidationException {
        InputValidationException.assertNotEmpty(name, DesignerMsg.METHOD_NAME_NOT_EMPTY);
        InputValidationException.assertTrue(Identifier.isValid(name), DesignerMsg.WRONGNAME);
        InputValidationException.assertFalse(Identifier.belongsToCIL(name), DesignerMsg.CIL_RESERVED_NAME);
        char c = name.charAt(0);
        InputValidationException.assertFalse(!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z'), DesignerMsg.CANT_START_NUMBER);
        Msg msg = XObjectTypeDescriptionHelper.validateMethodName((String)name);
        InputValidationException.assertNull(msg, msg);
    }

    public static boolean checkCilName(String cilName) {
        try {
            BPMObjectMethodInputValidator.validateName(cilName);
            return true;
        }
        catch (InputValidationException e) {
            MessageDialog.showError((Msg)DesignerMsg.WRONGNAME, (Msg)e.getKey());
            return false;
        }
    }

    public static boolean isXObjectAttribute(String name, ObjectTypeDescription xobj) {
        try {
            BPMObjectAttributeInputValidator.validateAttributeUniqueness(name, xobj);
            return true;
        }
        catch (InputValidationException e) {
            MessageDialog.showError((Msg)DesignerMsg.WRONGNAME, (Msg)e.getKey());
            return false;
        }
    }

    @Override
    public void validate(String name) throws InputValidationException {
        if (name == null) {
            return;
        }
        NewMethodAction.AccessorValidator av = new NewMethodAction.AccessorValidator(name, this.object);
        if (av.isAccessor()) {
            return;
        }
        BPMObjectMethodInputValidator.validateName(name);
        BPMObjectAttributeInputValidator.validateAttributeUniqueness(name, this.object);
        BPMObjectMethodInputValidator.validateMemberUniqueness(name, this.object);
    }

    protected static void validateMemberUniqueness(String name, ObjectTypeDescription object) throws InputValidationException {
        InputValidationException.assertNull(object.findMember(name, TypeFinder.Scope.DEFAULT), DesignerMsg.SELECTED_NAME_IS_IN_XOBJ_BASE);
    }
}

