/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class BPMObjectAttributeInputValidator
implements InputValidator {
    private ObjectTypeDescription object;

    public BPMObjectAttributeInputValidator(CatalogObject catalogObject) {
        this(catalogObject.getObjectType());
    }

    public BPMObjectAttributeInputValidator(ObjectTypeDescription object) {
        this.object = object;
    }

    @Override
    public void validate(String newAttributeName) throws InputValidationException {
        if (newAttributeName == null) {
            return;
        }
        InputValidationException.assertNotEmpty(newAttributeName, DesignerMsg.OBJECT_NAME_CANNOT_BE_EMPTY);
        BPMObjectAttributeInputValidator.validateAttributeUniqueness(newAttributeName, this.object);
        InputValidationException.assertTrue(XObjectTypeDescriptionHelper.isValidAttName((ObjectTypeDescription)this.object, (String)newAttributeName), DesignerMsg.INVALID_NAME);
    }

    protected static void validateAttributeUniqueness(String name, ObjectTypeDescription object) throws InputValidationException {
        InputValidationException.assertFalse(name != null && object.getMemberIndex(name, 18) >= 0, DesignerMsg.ATTRIBUTE_NAME_EXISTS);
    }
}

