/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer.action;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.LaneNameDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.command.design.AddLaneCommand;
import oracle.bpm.project.model.processes.Lane;
import oracle.bpm.project.model.processes.LaneUtils;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.Ui;
import org.jetbrains.annotations.NotNull;

public class AddLaneAction
extends DesignerAction {
    protected AddLaneCommand addLaneCommand;
    protected Lane newRole;
    protected int offset = -1;
    protected Process process;
    private String name;

    protected AddLaneAction(@NotNull Process process, int offset) {
        super(DesignerMsg.NEW_ROLE);
        this.requires(Process.class);
        this.process = process;
        this.offset = AddLaneAction.fixOffset(process, offset);
    }

    public static LaneInfo newLaneName(Process process, boolean includeAutomatic, boolean includeParametric) {
        LaneNameDialog dialog = new LaneNameDialog(Ui.getRoot(), process, includeAutomatic, includeParametric, null);
        dialog.setVisible(true);
        return dialog.userAccepted() ? new LaneInfo(dialog.getLaneName(), dialog.getParamVariable()) : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setNewRole(Lane newRole) {
        this.newRole = newRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        LaneInfo laneInfo = this.askLaneInfo();
        if (laneInfo != null) {
            this.getRunner().run((Command)new AddLaneCommand(this.process, laneInfo.getLaneName(), laneInfo.getVariableName(), this.offset));
        }
    }

    protected LaneInfo askLaneInfo() {
        return this.getName() == null ? this.establishNewRoleName() : new LaneInfo(this.getName(), null);
    }

    private static int fixOffset(Process process, int offset) {
        if (offset < 0) {
            Lane last = LaneUtils.getLastLane((Process)process);
            offset = last.getOffset() + last.getSize() + 1;
        }
        return offset;
    }

    private LaneInfo establishNewRoleName() {
        LaneInfo result = null;
        if (this.newRole != null && this.newRole.getId() != null) {
            result = new LaneInfo(this.newRole.getId(), null);
        } else {
            this.newRole = null;
            if (this.name == null || this.name.equals(DesignerMsg.NEW.getString())) {
                result = AddLaneAction.newLaneName(this.process, true, true);
            }
        }
        return result;
    }

    public static class LaneInfo {
        String laneId;
        String variableName;

        LaneInfo(String laneName, String variableName) {
            this.laneId = laneName;
            this.variableName = variableName;
        }

        public String getLaneName() {
            return this.laneId;
        }

        public String getVariableName() {
            return this.variableName;
        }
    }
}

