/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.command.Command;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.project.command.design.ChangeScaleCommand;
import oracle.bpm.project.model.features.ViewScaleFeature;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.msg.UIMsg;
import org.jetbrains.annotations.NotNull;

public class ZoomInAction
extends DesignerAction {
    private final ProcessDomain domain;

    public ZoomInAction(@NotNull ProcessDomain domain) {
        super(UIMsg.ZOOM_IN);
        this.domain = domain;
    }

    @Override
    public void run() {
        if (this.domain.getDrawContext().getScale() >= ViewScaleFeature.MAXIMUM_SCALE.floatValue()) {
            return;
        }
        Process process = this.domain.getDomainElement();
        ViewScaleFeature scale = (ViewScaleFeature)process.getFeature(ViewScaleFeature.class);
        this.getRunner().run((Command)new ChangeScaleCommand(process, scale.getValue().floatValue() + ViewScaleFeature.INCREMENT_SCALE.floatValue()));
        this.domain.getDrawContext().setScale(scale.getValue().floatValue());
        this.domain.getCanvas().repaint();
    }
}

