/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.CatalogObjectEditor;
import oracle.bpm.designer.EditorType;
import oracle.bpm.designer.action.FuegoObjectAction;
import oracle.bpm.designer.action.NewAttributeAction;
import oracle.bpm.designer.action.OpenCloseMemberAction;
import oracle.bpm.designer.action.OpenComponentAction;
import oracle.bpm.designer.catalog.CatalogUtils;
import oracle.bpm.designer.catalog.bpmobjects.BPMObjectEditor;
import oracle.bpm.designer.catalog.panel.CatalogObjectHeaderPanel;
import oracle.bpm.designer.catalog.panel.CatalogObjectTable;
import oracle.bpm.designer.catalog.panel.CatalogObjectTableModel;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.catalog.BpmObject;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.editors.TableCellEditor;
import oracle.bpm.ui.text.TextField;

@Deprecated
public class XObjectComponentStructurePanel
extends CatalogObjectEditor {
    private BPMObjectEditor bpmObjectEditor;
    private ProjectListenerAdapter<CatalogMember> catalogMemberListener;
    private CatalogObjectHeaderPanel headerPanel;
    private CatalogObjectTable memberTable;
    private ObjectTypeDescription objectTypeDescription;
    private TextField primaryKey;
    private CatalogObjectTableModel tableModel;

    public XObjectComponentStructurePanel(UiContainer parent, CatalogObject object) {
        super(parent, object);
        this.objectTypeDescription = object.getObjectType();
        this.setReadOnly(((CatalogObject)this.getProjectObject()).isReadOnly());
    }

    @Override
    public EditorType getEditorType() {
        return EditorType.FOBJECT;
    }

    @Override
    public void openPart(Object part) {
    }

    @Deprecated
    public void refreshStructure() {
        this.objectTypeDescription = (ObjectTypeDescription)this.getObjectTypeDescription().getRef().get();
        CatalogMember member = this.memberTable.getSelectedMember();
        int newRow = this.tableModel.getRowIndex(member);
        if (newRow >= 0 && newRow < this.tableModel.getRowCount()) {
            this.memberTable.setSelectionInterval(newRow, newRow);
        }
        this.refreshPrimaryKeyText();
    }

    @Deprecated
    public void stateChanged(ChangeEvent e) {
    }

    public ObjectTypeDescription getObjectTypeDescription() {
        if (this.objectTypeDescription == null) {
            return ((CatalogObject)this.getProjectObject()).getObjectType();
        }
        return this.objectTypeDescription;
    }

    public void setBPMObjectEditor(BPMObjectEditor bpmObjectEditor) {
        this.bpmObjectEditor = bpmObjectEditor;
    }

    @Override
    public void disposeEditor() {
        super.disposeEditor();
        ((CatalogObject)this.getProjectObject()).getProject().removeListener(this.getProjectListener());
        this.removePropertiesObeserver(this.getObjectTypeDescription());
    }

    public void onDispose() {
    }

    public void refreshPrimaryKeyText() {
        this.primaryKey.setText(CatalogUtils.getPrimaryKeyText(this.getObjectTypeDescription()));
    }

    public void repaintTable() {
        this.memberTable.repaint();
    }

    public void tableDataChanged() {
    }

    @Override
    public void setDirty(boolean dirty) {
        super.setDirty(dirty);
    }

    @Override
    protected void editorToObject() {
    }

    @Override
    protected void objectToEditor() {
    }

    @Override
    protected void buildUI(UiContainer parent) {
        Panel container = new Panel(parent);
        container.setLayout((Layout)new BorderLayout());
        this.headerPanel = new CatalogObjectHeaderPanel(parent, (CatalogObject)this.getProjectObject());
        this.primaryKey = new TextField(parent);
        this.primaryKey.setEditable(false);
        this.primaryKey.setOpaque(false);
        ((CatalogObject)this.getProjectObject()).getProject().addListener(this.getProjectListener());
        ObjectTypeDescription otd = this.getObjectTypeDescription();
        this.tableModel = new CatalogObjectTableModel((CatalogObject)this.getProjectObject());
        this.addPropertiesObserver(otd);
        this.memberTable = CatalogObjectTable.create((UiContainer)container, this.tableModel);
        final BaseAction removeAction = new BaseAction(UIMsg.REMOVE){

            public void actionPerformed(ActionEvent e) {
                XObjectComponentStructurePanel.this.stopEdition();
                MethodTypeDescription member = XObjectComponentStructurePanel.this.memberTable.getSelectedMember().getMemberType();
                boolean isGroupAttribute = XObjectTypeDescription.isGroupAttribute(member.asAttribute());
                if (isGroupAttribute) {
                    FuegoObjectAction.storeObject(member.getParent().asObject());
                }
            }
        };
        final BaseAction openAction = new BaseAction(UIMsg.OPEN){

            public void run() {
                XObjectComponentStructurePanel.this.openSelected();
            }
        };
        final BaseAction moveUpAction = new BaseAction(UIMsg.MOVE_UP){

            public void run() {
                XObjectComponentStructurePanel.this.stopEdition();
                int row = XObjectComponentStructurePanel.this.memberTable.getSelectedRow();
                if (XObjectComponentStructurePanel.this.tableModel.canMoveRowUp(row)) {
                    boolean newPosition = true;
                    XObjectComponentStructurePanel.this.memberTable.setSelectionInterval(1, 1);
                }
            }
        };
        final BaseAction moveDownAction = new BaseAction(UIMsg.MOVE_DOWN){

            public void run() {
                XObjectComponentStructurePanel.this.stopEdition();
                int row = XObjectComponentStructurePanel.this.memberTable.getSelectedRow();
                if (XObjectComponentStructurePanel.this.tableModel.canMoveRowDown(row)) {
                    boolean newPosition = true;
                    XObjectComponentStructurePanel.this.memberTable.setSelectionInterval(1, 1);
                }
            }
        };
        BaseAction addAction = new BaseAction(UIMsg.ADD){

            public void run() {
                BpmObject catalogObject = CatalogObjectImpl.create((TypeRef)XObjectComponentStructurePanel.this.objectTypeDescription).asBpmObject();
                NewAttributeAction.silentCreate(catalogObject);
            }
        };
        moveDownAction.setEnabled(false);
        moveUpAction.setEnabled(false);
        removeAction.setEnabled(false);
        openAction.setEnabled(false);
        this.memberTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                boolean enable = !XObjectComponentStructurePanel.this.isReadOnly();
                int index = XObjectComponentStructurePanel.this.memberTable.getSelectedRow();
                moveDownAction.setEnabled(enable && XObjectComponentStructurePanel.this.tableModel.canMoveRowDown(index));
                moveDownAction.setEnabled(enable);
                moveUpAction.setEnabled(enable && XObjectComponentStructurePanel.this.tableModel.canMoveRowUp(index));
                moveUpAction.setEnabled(enable);
                removeAction.setEnabled(enable && XObjectComponentStructurePanel.this.tableModel.isRowEditable(index));
                removeAction.setEnabled(enable);
                openAction.setEnabled(index >= 0);
            }
        });
        ToolBar toolBar = new ToolBar((UiContainer)container, ToolBar.VERTICAL);
        toolBar.add(addAction);
        toolBar.add(removeAction);
        toolBar.add(openAction);
        toolBar.addSeparator();
        toolBar.add(moveUpAction);
        toolBar.add(moveDownAction);
        container.add((UiComponent)this.memberTable, (Object)"Center");
        container.add((UiComponent)toolBar, (Object)"East");
        String columns = "5dlu, fill:pref:grow, 5dlu";
        String rows = "5dlu, pref,5dlu, fill:pref:grow, 5dlu, pref";
        FormLayout thisLayout = new FormLayout("5dlu, fill:pref:grow, 5dlu", "5dlu, pref,5dlu, fill:pref:grow, 5dlu, pref");
        PanelBuilder thisBuilder = new PanelBuilder(thisLayout, parent);
        CellConstraints cc = thisLayout.createCellConstraints();
        thisBuilder.add((UiComponent)this.headerPanel, cc.xy(2, 2));
        thisBuilder.add((UiComponent)container, cc.xy(2, 4));
        thisBuilder.add((UiComponent)this.primaryKey, cc.xywh(1, 6, 3, 1));
        this.refreshPrimaryKeyText();
    }

    @Override
    protected void stopEdition() {
        TableCellEditor editor = this.memberTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    private void openAttribute(MethodTypeDescription mtd) {
        this.bpmObjectEditor.openMember(mtd, -1);
    }

    private void removePropertiesObeserver(ObjectTypeDescription otd) {
        for (MethodTypeDescription methodTypeDescription : otd.getAttributes()) {
        }
    }

    private void addPropertiesObserver(ObjectTypeDescription otd) {
        for (MethodTypeDescription methodTypeDescription : otd.getAttributes()) {
        }
    }

    private void adjustColumnSizes() {
    }

    private MutableComponentCatalog getTypeRepository() {
        return (MutableComponentCatalog)this.getObjectTypeDescription().getCatalog();
    }

    private void openSelected() {
        MethodTypeDescription mtd = this.memberTable.getSelectedMember().getMemberType();
        if (mtd != null && mtd.getParent() != null) {
            ObjectTypeDescription otd = mtd.getParent().asObject();
            if (otd.isBpmObject()) {
                if (otd.equivalent(this.getObjectTypeDescription())) {
                    this.openAttribute(mtd);
                } else {
                    OpenCloseMemberAction.openMember(mtd);
                }
            } else {
                new OpenComponentAction(otd).run();
            }
        }
    }

    private ProjectListener<CatalogMember> getProjectListener() {
        if (this.catalogMemberListener == null) {
            this.catalogMemberListener = new ProjectListenerAdapter<CatalogMember>(CatalogMember.class){

                public void postObjectAdded(CatalogMember member, ProjectObject parent) {
                    if (member.getParentObject() == XObjectComponentStructurePanel.this.getProjectObject()) {
                        System.out.println("member = " + member);
                        XObjectComponentStructurePanel.this.tableModel.addRow(member);
                    }
                }

                public void postObjectRemoved(CatalogMember member, ProjectObject parent) {
                    if (member.getParentObject() == XObjectComponentStructurePanel.this.getProjectObject()) {
                        System.out.println("member = " + member);
                        XObjectComponentStructurePanel.this.tableModel.removeRow(XObjectComponentStructurePanel.this.tableModel.getRowIndex(member));
                    }
                }
            };
        }
        return this.catalogMemberListener;
    }
}

