/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.IOException;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.themes.ImageType;
import oracle.bpm.geom.Insets;
import oracle.bpm.log.Log;
import oracle.bpm.project.model.processes.Activity;
import oracle.bpm.project.model.processes.FlowElement;
import oracle.bpm.project.model.processes.activities.CustomImageFeature;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class Utility {
    public static String getHTMLMessage(String message) {
        StringTokenizer tokenizer = new StringTokenizer(message, "\n");
        StringBuffer buffer = new StringBuffer("<html>");
        boolean first = true;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (first) {
                first = false;
            } else {
                buffer.append("<br/>");
            }
            buffer.append(token);
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public static void constrain(UiContainer container, UiComponent component, int grid_x, int grid_y, int grid_width, int grid_height, int fill, int anchor, double weight_x, double weight_y, int top, int left, int bottom, int right) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = grid_x;
        c.gridy = grid_y;
        c.gridwidth = grid_width;
        c.gridheight = grid_height;
        c.fill = fill;
        c.anchor = anchor;
        c.weightx = weight_x;
        c.weighty = weight_y;
        if (top + bottom + left + right > 0) {
            c.insets = new Insets(top, left, bottom, right);
        }
        container.add(component, (Object)c);
    }

    public static Image getActivityImage(@NotNull Activity fuegoActivity) {
        return Utility.getActivityImage(fuegoActivity, ImageType.NORMAL);
    }

    public static Image getActivityImage(@NotNull Activity fuegoActivity, @NotNull ImageType type) {
        Image result = ((CustomImageFeature)fuegoActivity.getFeature(CustomImageFeature.class)).getUseLocalImageFeature().getValue() == false ? DesignerPreferences.getPreferences().getTheme().getImageFor((FlowElement)fuegoActivity, type) : Utility.getCustomActivityImage(fuegoActivity);
        return result;
    }

    private static Image getCustomActivityImage(@NotNull Activity fuegoActivity) {
        Image result = null;
        try {
            String base64 = ((CustomImageFeature)fuegoActivity.getFeature(CustomImageFeature.class)).getEncodedLocalImage();
            result = Image.createFromBase64((String)base64);
        }
        catch (IOException e) {
            Log.logWarning(e);
        }
        catch (IllegalArgumentException e) {
            Log.logWarning(e);
        }
        return result;
    }
}

