/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.File;
import java.io.FilenameFilter;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.util.FuegoDirectories;

public class UnsavedProcessesChecker
implements Runnable {
    private DesignerApplication application;

    public UnsavedProcessesChecker(DesignerApplication application) {
        this.application = application;
    }

    public DesignerApplication getApplication() {
        return this.application;
    }

    @Override
    public void run() {
        this.checkForNonSavedProcesses();
    }

    private void checkForNonSavedProcesses() {
        File directory = FuegoDirectories.home();
        String[] files = directory.list(this.createFileFilter());
        if (files.length == 0) {
            return;
        }
        int result = MessageDialog.showQuestion((UiContainer)null, (Msg)CoreMsg.WARNING, (Msg)DesignerMsg.FOUND_NON_SAVED_FILES, null, (int)6, null);
        if (result != 2) {
            this.removeTempFiles(files);
            return;
        }
    }

    private FilenameFilter createFileFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return name.startsWith("~");
            }
        };
    }

    private void removeTempFiles(String[] files) {
        for (int i = 0; i < files.length; ++i) {
            FuegoDirectories.homeRelativeFile(files[i]).delete();
        }
    }
}

