/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.TypeFilter;
import oracle.bpm.designer.action.HideComponentAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeInfo;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;

@Deprecated
public class TypesFilter
implements TypeFilter {
    private int[] excludeModifiers;
    private int modifiers;
    public static final int IMPLEMENTATION_COMPONENTS = 1;
    public static final int METHODS = 2;
    public static final int ATTRIBUTES = 4;
    public static final int IMPLEMENTATION_MODULES = 8;
    public static final int USER_MODULES = 16;
    public static final int TRANSFORMS = 32;
    public static final int DEFAULT_MODULES = 64;
    public static final int PROCESSES = 128;
    public static final int ONLY_PROCESSESDIR = 256;
    public static final int XOBJECTS = 512;
    public static final int EXCEPTIONS = 1024;
    public static final int EXTERNAL_RESOURCES = 2048;
    public static final int MEMBERS = 4096;
    public static final int DEFAULT_TYPE = 8192;
    public static final int USER_DEFINED_TYPE = 16384;
    public static final int RUNS_ON_CLIENT = 32768;
    public static final int PRESENTABLE = 65536;
    public static final int RUNS_ON_SERVER = 131072;
    public static final int SHOW_GROUPS = 262144;
    public static final int ABSTRACT = 524288;
    public static final int PORT_TYPE = 0x100000;
    public static final int VIEWS = 0x200000;
    public static final int RESOURCES = 0x400000;
    public static final int JSPS = 0x800000;
    public static final int HIDDEN_COMPONENTS = 0x1000000;
    public static final int SCREENFLOWS = 0x2000000;
    public static final int PROCEDURES = 0x4000000;
    public static final int BPEL_PROCESSES = 0x8000000;
    public static final int SIMULATIONS = 0x10000000;
    public static final int ORGANIZATION = 0x20000000;
    public static final int JMX_WITH_NOTIFICATIONS = 0x40000000;
    public static final int PUNIT_SUITE = Integer.MIN_VALUE;
    public static final int WEB_ROOT = 0xC00000;
    public static final int MODULES = 88;
    public static final int COMPONENTS = 1312345;
    public static final int CATALOG = 1314431;
    public static final int PROCESSES_AND_CATALOG = 1055923967;
    public static final int CATALOG_ONLY_USER_MODULES_AND_USER_COMPONENTS = 0x100211;
    public static final int BUSINESS_ANALYST = 0x30000080;

    public TypesFilter(int modifiers) {
        this.modifiers = modifiers;
    }

    public TypesFilter(int modifiers, int excludeModifiers) {
        this.modifiers = modifiers;
        this.excludeModifiers = new int[]{excludeModifiers};
    }

    public TypesFilter(int modifiers, int[] excludeModifiers) {
        this.modifiers = modifiers;
        this.excludeModifiers = excludeModifiers;
    }

    public Msg getInvalidSelectionMsg(String componentName) {
        return DesignerMsg.CANNOT_SELECT_THIS_TYPE_IN_THIS_CONTEXT(componentName);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public boolean isValid(TypeRef type, ComponentCatalog catalog) {
        String typeText = type.getText();
        if (typeText.startsWith("Fuego.Internal") || typeText.startsWith("CurrentProject") || typeText.startsWith("Fuego__AutoGen__Project__") || "Fuego.Util.Functions".equals(typeText)) {
            return false;
        }
        TypeInfo info = catalog == null ? null : ((MutableComponentCatalog)catalog).getInfo(type);
        return info != null && this.checkHidden(type) && this.isValid(TypesFilter.getModifiers(info, type, catalog));
    }

    @Override
    public boolean isValid(TypeRef ref) {
        return this.isValid(ref, ref.getCatalog());
    }

    @Override
    public boolean acceptDefaultComponents() {
        return this.isDefaultComponent();
    }

    public boolean isDefaultComponent() {
        return (this.getModifiers() & 0x40) != 0 || (this.getModifiers() & 0x2000) != 0;
    }

    public boolean acceptSelectionModules() {
        int mods = this.getModifiers();
        return !((mods & 8) == 0 && (mods & 0x10) == 0 && (mods & 0x40) == 0 || (mods & 1) != 0 && (mods & 0x200) != 0 && (mods & 0x100000) != 0 && (mods & 0x400) != 0 && (mods & 0x40000) != 0);
    }

    private static int getModifiers(TypeInfo info, TypeRef type, ComponentCatalog catalog) {
        int modifiers = 0;
        String componentType = info.getType();
        long flags = type.getModifiers();
        if (Modifier.isPresentable(flags)) {
            modifiers |= 0x10000;
        }
        modifiers = componentType.equals(ComponentType.XOBJECT.getText()) ? (modifiers |= 0x200) : (componentType.equals(ComponentType.OBJECT.getText()) && !TypeUtils.belongsToDefaultCatalog(type) ? (modifiers |= 0x10) : (componentType.equals(ComponentType.PORT_TYPE.getText()) ? (modifiers |= 0x100000) : (!catalog.hasChildren(type) ? (modifiers |= 1) : (modifiers |= 8))));
        if (componentType.equals("jmx") && Boolean.TRUE.toString().equals(info.getProperty("hasNotifications"))) {
            modifiers |= 0x40000000;
        }
        if (Modifier.isAbstract(flags)) {
            modifiers |= 0x80000;
        }
        if (type instanceof MethodTypeDescription) {
            MethodTypeDescription member = (MethodTypeDescription)type;
            if (member.isAttribute()) {
                modifiers |= 4;
            } else if (member.isMethod()) {
                modifiers |= 2;
            } else if (member.isTransformation()) {
                modifiers |= 0x20;
            }
        }
        modifiers = Modifier.isRunsOnClient(flags) || info.isRemote() ? (modifiers |= 0x8000) : (modifiers |= 0x20000);
        if (Modifier.isException(flags)) {
            modifiers |= 0x400;
        }
        if (Modifier.isPUnitSuite(flags)) {
            modifiers |= Integer.MIN_VALUE;
        }
        modifiers = TypeUtils.belongsToDefaultCatalog(type) ? (modifiers |= 0x2000) : (modifiers |= 0x4000);
        if (HideComponentAction.isUIHidden(type)) {
            modifiers |= 0x1000000;
        }
        return modifiers;
    }

    private boolean isValid(int modifier) {
        boolean res;
        boolean bl = res = this.modifiers == -1 || (modifier & this.modifiers) != 0;
        if (res && this.excludeModifiers != null) {
            boolean exclude = true;
            for (int excludeModifier : this.excludeModifiers) {
                exclude = exclude && (modifier & excludeModifier) != 0;
            }
            res = !exclude;
        }
        return res;
    }

    private boolean checkHidden(TypeRef type) {
        return (this.modifiers & 0x1000000) == 0x1000000 || !HideComponentAction.isUIHidden(type);
    }
}

