/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.bpm.designer.TypeFilter;
import oracle.bpm.lang.Cast;
import oracle.bpm.lang.Str;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeList;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.ui.text.DefaultDictionary;
import org.jetbrains.annotations.Nullable;

public class TypesDictionary
extends DefaultDictionary {
    private final String[] emptyArray = new String[]{""};
    private ComponentCatalog repository;
    private TypeFilter typeFilter;
    private final List<TypeRef> valueList = new ArrayList<TypeRef>();

    public TypesDictionary(ComponentCatalog repository) {
        this(repository, null);
    }

    public TypesDictionary(ComponentCatalog repository, TypeFilter filter) {
        this.repository = repository;
        this.typeFilter = filter;
    }

    public void setTypeFilter(TypeFilter typeFilter) {
        this.typeFilter = typeFilter;
    }

    public List<TypeRef> getValueList() {
        return this.valueList;
    }

    public String[] lookup(String s) {
        this.valueList.clear();
        if (Str.isEmpty(s)) {
            return this.emptyArray;
        }
        Map types = (Map)Cast.force(this.repository.findByPartialName(s));
        Map libraryTypes = (Map)Cast.force(TypeUtils.getDefaultCatalog().findByPartialName(s));
        this.addTypes(this.valueList, types);
        this.addTypes(this.valueList, libraryTypes);
        return this.valueList.isEmpty() ? super.lookup(s) : TypeUtils.typeShortNames(this.valueList).toArray(new String[this.valueList.size()]);
    }

    private void addTypes(List<TypeRef> typeRefs, @Nullable Map<String, TypeList> typeListMap) {
        if (typeListMap != null) {
            for (TypeList typeList : typeListMap.values()) {
                for (TypeList type : typeList) {
                    this.addType(type, typeRefs);
                }
            }
        }
    }

    private void addType(TypeRef type, List<TypeRef> list) {
        if (this.typeFilter == null || this.typeFilter.isValid(type)) {
            list.add(type);
        }
    }
}

