/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.AbstractTypesBrowserModel;
import oracle.bpm.designer.AutoCompleteTypesBrowserModelAdapter;
import oracle.bpm.designer.ComboStringTypesBrowserModelAdapter;
import oracle.bpm.designer.ComboTypesBrowserModelAdapter;
import oracle.bpm.designer.InvalidTypeException;
import oracle.bpm.designer.StringFeatureTypeBrowserAdapter;
import oracle.bpm.designer.StringsComboTypesBrowserModelAdapter;
import oracle.bpm.designer.TextComponentTypesBrowserModelAdapter;
import oracle.bpm.designer.TypeValidator;
import oracle.bpm.designer.activitiespanels.StringFeatureEditor;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.ComboBox;
import oracle.bpm.ui.text.AutoCompleteTextPanel;
import oracle.bpm.ui.text.TextComponent;
import org.jetbrains.annotations.NotNull;

public interface TypesBrowserModel {
    public TypeRef getType();

    public void setType(TypeRef var1) throws InvalidTypeException;

    public static class InitialValue
    extends AbstractTypesBrowserModel {
        @NotNull
        private TypeRef typeRef;

        public InitialValue(@NotNull TypeRef typeRef) {
            this.typeRef = typeRef;
            this.addValidator(new TypeValidator.NotNull());
        }

        @Override
        @NotNull
        public TypeRef getType() {
            return this.typeRef;
        }

        @Override
        protected void innetSetType(@NotNull TypeRef typeRef) {
            this.typeRef = typeRef;
        }
    }

    public static class TypesBrowserModelUtils {
        public static AbstractTypesBrowserModel adapt(TextComponent text, ComponentCatalog catalog) {
            return new TextComponentTypesBrowserModelAdapter(text, catalog);
        }

        public static AbstractTypesBrowserModel adapt(ComboBox<TypeRef> combo) {
            return new ComboTypesBrowserModelAdapter(combo);
        }

        public static AbstractTypesBrowserModel adapt(ComboBox<String> combo, ComponentCatalog catalog) {
            return new ComboStringTypesBrowserModelAdapter(combo, catalog);
        }

        public static AbstractTypesBrowserModel adaptStringsCombo(ComboBox<String> combo, ComponentCatalog catalog) {
            return new StringsComboTypesBrowserModelAdapter(combo, catalog);
        }

        public static AbstractTypesBrowserModel adapt(AutoCompleteTextPanel combo, ComponentCatalog catalog) {
            return new AutoCompleteTypesBrowserModelAdapter(combo, catalog);
        }

        public static TypesBrowserModel adapt(StringFeatureEditor stringFeatureEditor, ComponentCatalog catalog) {
            return new StringFeatureTypeBrowserAdapter(stringFeatureEditor, catalog);
        }
    }
}

