/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bpm.geom.Insets;
import oracle.bpm.lang.Interval;
import oracle.bpm.lang.Time;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.AbstractButton;
import oracle.bpm.ui.ButtonGroup;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.RadioButton;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.FlowLayout;
import oracle.bpm.ui.layout.GridBagConstraints;
import oracle.bpm.ui.layout.GridBagLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.text.DecimalDocument;
import oracle.bpm.ui.text.IntervalField;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.ui.text.TimeField;

class TypeDependantField
extends Panel {
    protected TypeRef currentType_d;
    protected RadioButton defaultBool_d;
    protected CheckBox defaultBoolCheck_d;
    protected RadioButton defaultBoolfalse;
    protected Panel defaultBoolPanel_d;
    protected TextField defaultField_d;
    protected IntervalField defaultInterval_d;
    protected TimeField defaultTime_d;

    public TypeDependantField(UiContainer parent, TypeDescription type) {
        super(parent);
        if (type == null) {
            type = TypeFactory.getString();
        }
        this.currentType_d = type;
        this.build();
    }

    public void setEnabled(boolean value) {
        this.defaultField_d.setEnabled(value);
        this.defaultTime_d.setEnabled(value);
        this.defaultInterval_d.setEnabled(value);
        this.defaultBoolPanel_d.setEnabled(value);
    }

    public void setType(TypeRef newType) {
        this.currentType_d = newType;
        this.updateView();
    }

    public void setValue(String value) {
        switch (this.currentType_d.get().getKind()) {
            case 6: {
                this.defaultTime_d.setTime(Time.valueOf(value));
                return;
            }
            case 7: {
                this.defaultInterval_d.setInterval(Interval.valueOf(value));
                return;
            }
            case 1: {
                this.defaultBool_d.setSelected(Boolean.valueOf(value).booleanValue());
                if (!this.defaultBool_d.isSelected()) {
                    this.defaultBoolfalse.setSelected(true);
                }
                return;
            }
            case 5: {
                this.defaultField_d.setText(value);
            }
        }
        this.defaultField_d.setText(value);
    }

    public String getValue() {
        if (this.currentType_d == null) {
            return this.defaultField_d.getText();
        }
        switch (this.currentType_d.get().getKind()) {
            case 6: {
                return this.defaultTime_d.getTime() == null ? "" : this.defaultTime_d.getTime().toString();
            }
            case 7: {
                return this.defaultInterval_d.getInterval() == null ? "" : this.defaultInterval_d.getInterval().toString();
            }
            case 1: {
                return String.valueOf(this.defaultBool_d.isSelected());
            }
            case 5: {
                return this.defaultField_d.getText();
            }
        }
        return this.defaultField_d.getText();
    }

    private GridBagConstraints getFldConstraints(int gridx, int gridy) {
        GridBagConstraints constr = new GridBagConstraints();
        constr.gridx = gridx;
        constr.gridy = gridy;
        constr.fill = 0;
        constr.anchor = 17;
        constr.insets = new Insets(0, 0, 0, 0);
        return constr;
    }

    private void build() {
        this.defaultField_d = new TextField((UiContainer)this, 20);
        this.defaultBool_d = new RadioButton((UiContainer)this, "True");
        this.defaultBoolfalse = new RadioButton((UiContainer)this, "False");
        ButtonGroup g = new ButtonGroup();
        g.add((AbstractButton)this.defaultBool_d);
        g.add((AbstractButton)this.defaultBoolfalse);
        this.defaultBoolfalse.setSelected(true);
        this.defaultTime_d = new TimeField((UiContainer)this);
        this.defaultInterval_d = new IntervalField((UiContainer)this);
        this.defaultBoolPanel_d = new Panel((UiContainer)this);
        this.defaultBool_d.setLayout((Layout)new FlowLayout());
        this.defaultBoolPanel_d.add((UiComponent)this.defaultBool_d);
        this.defaultBoolPanel_d.add((UiComponent)this.defaultBoolfalse);
        this.setLayout((Layout)new GridBagLayout());
        this.add((UiComponent)this.defaultField_d, this.getFldConstraints(0, 0));
        this.add((UiComponent)this.defaultBoolPanel_d, this.getFldConstraints(0, 0));
        this.add((UiComponent)this.defaultTime_d, this.getFldConstraints(0, 0));
        this.add((UiComponent)this.defaultInterval_d, this.getFldConstraints(0, 0));
        this.updateView();
    }

    private void updateView() {
        this.defaultField_d.setVisible(false);
        this.defaultTime_d.setVisible(false);
        this.defaultInterval_d.setVisible(false);
        this.defaultBoolPanel_d.setVisible(false);
        this.defaultField_d.setEnabled(true);
        if (this.currentType_d == null) {
            this.defaultField_d.setDocument((Document)new PlainDocument());
            this.defaultField_d.setEnabled(false);
            this.defaultField_d.setText("");
        } else {
            switch (this.currentType_d.get().getKind()) {
                case 3: 
                case 4: {
                    new DecimalDocument(this.defaultField_d);
                    break;
                }
                case 2: {
                    new DecimalDocument((TextField)this.defaultField_d).decimal = 0;
                    break;
                }
                case 6: {
                    this.defaultTime_d.setVisible(true);
                    return;
                }
                case 7: {
                    this.defaultInterval_d.setVisible(true);
                    break;
                }
                case 1: {
                    this.defaultBoolPanel_d.setVisible(true);
                    return;
                }
                case 5: {
                    this.defaultField_d.setDocument((Document)new PlainDocument());
                    break;
                }
                default: {
                    this.defaultField_d.setText("");
                    this.defaultField_d.setEnabled(false);
                }
            }
        }
        this.getOwnerWindow().pack();
        this.defaultField_d.setVisible(true);
    }
}

