/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.geom.Dimension;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ExclusiveGateway;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.transitions.TransitionOrderFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.ActionListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.forms.FormsFactory;
import oracle.bpm.ui.forms.StandardForm;
import oracle.bpm.ui.layout.BoxLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.table.AbstractTableModel;
import oracle.bpm.ui.table.Table;
import oracle.bpm.ui.table.TableModel;

public class TransitionsOrderPanel
extends ProjectObjectEditorPanel<ExclusiveGateway> {
    private Table transitionsTable;

    public TransitionsOrderPanel(UiContainer parent, ExclusiveGateway activity) {
        super(parent, activity);
        this.init();
    }

    public void ok() {
    }

    @Override
    public void objectToEditor(ExclusiveGateway projectObject) {
    }

    @Override
    public ExclusiveGateway editorToObject() {
        TransitionTableModel model = this.getModel();
        for (int row = 0; row < model.getRowCount(); ++row) {
            SequenceFlow fuegoTransition = this.getModel().getTransition(row);
            TransitionOrderFeature tInfo = (TransitionOrderFeature)fuegoTransition.getFeature(TransitionOrderFeature.class);
            tInfo.setValue(Integer.valueOf(row));
        }
        return (ExclusiveGateway)this.getProjectObject();
    }

    @Override
    public void validatePanel() throws ProjectException {
    }

    private TransitionTableModel getModel() {
        return (TransitionTableModel)this.transitionsTable.getModel();
    }

    private Button createButton(UiContainer parent, Msg msg) {
        Button button = new Button(parent, msg, 10);
        button.setBorder(BorderFactory.createEmptyBorder((int)1, (int)1, (int)1, (int)1));
        button.setEnabled(false);
        return button;
    }

    private void init() {
        StandardForm form = FormsFactory.createStandardForm((UiContainer)this);
        Panel mainPanel = new Panel(this.getParent());
        Panel buttonsPanel = new Panel((UiContainer)mainPanel);
        TransitionTableModel model = new TransitionTableModel((ExclusiveGateway)this.getProjectObject());
        this.transitionsTable = new Table((UiContainer)mainPanel, (TableModel)model, ListSelectionMode.SINGLE_SELECTION);
        this.transitionsTable.setReorderingAllowed(false);
        this.transitionsTable.setShowHorizontalLines(true);
        this.transitionsTable.setRelativeSizes(new double[]{0.1, 0.7});
        final Button upButton = this.createButton((UiContainer)buttonsPanel, UIMsg.MOVE_UP);
        upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = TransitionsOrderPanel.this.transitionsTable.getSelectedRow();
                if (index == 0) {
                    return;
                }
                TransitionsOrderPanel.this.processButton(index, index - 1);
            }
        });
        final Button downButton = this.createButton((UiContainer)buttonsPanel, UIMsg.MOVE_DOWN);
        downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = TransitionsOrderPanel.this.transitionsTable.getSelectedRow();
                if (index == TransitionsOrderPanel.this.transitionsTable.getRowCount() - 1) {
                    return;
                }
                TransitionsOrderPanel.this.processButton(index, index + 1);
            }
        });
        this.transitionsTable.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                int index = TransitionsOrderPanel.this.transitionsTable.getSelectedRow();
                downButton.setEnabled(index < TransitionsOrderPanel.this.transitionsTable.getRowCount() - 1);
                upButton.setEnabled(index > 0);
            }
        });
        mainPanel.setLayout((Layout)new BorderLayout(5, 5));
        buttonsPanel.setLayout((Layout)new BoxLayout((UiContainer)buttonsPanel, 1));
        buttonsPanel.add((UiComponent)upButton);
        buttonsPanel.add((UiComponent)downButton);
        this.transitionsTable.setPreferredSize(Dimension.valueOf(300, 200));
        mainPanel.add((UiComponent)this.transitionsTable, (Object)"Center");
        mainPanel.add((UiComponent)buttonsPanel, (Object)"East");
        form.add((UiComponent)mainPanel);
        this.transitionsTable.setSelectionInterval(0, 0);
        this.setSize(400, 300);
    }

    private void processButton(int oldIndex, int newIndex) {
        if (oldIndex == -1) {
            MessageDialog.showError((Msg)DesignerMsg.NO_SEQUENCEFLOW_SELECTED);
            return;
        }
        this.getModel().switchRows(oldIndex, newIndex);
        this.transitionsTable.setSelectionInterval(newIndex, newIndex);
    }

    private static class TransitionTableModel
    extends AbstractTableModel {
        private List<SequenceFlow> list;
        private final Msg[] titles = new Msg[]{ProjectMsg.ORDER, DesignerMsg.TARGET};
        private static int COLUMN_ORDER = 0;

        TransitionTableModel(ExclusiveGateway exclusiveGateway) {
            this.list = new ArrayList<SequenceFlow>();
            exclusiveGateway.getOutgoingConditionalFlows().addAllTo(this.list);
            Collections.sort(this.list, new Comparator<SequenceFlow>(){

                @Override
                public int compare(SequenceFlow o1, SequenceFlow o2) {
                    return ((Integer)o1.getFeatureValue(TransitionOrderFeature.class)).compareTo((Integer)o2.getFeatureValue(TransitionOrderFeature.class));
                }
            });
        }

        public int getColumnCount() {
            return this.titles.length;
        }

        public String getColumnName(int column) {
            return this.titles[column].getString();
        }

        public int getRowCount() {
            return this.list.size();
        }

        public SequenceFlow getTransition(int row) {
            return this.list.get(row);
        }

        public Object getValueAt(int row, int column) {
            if (column == COLUMN_ORDER) {
                return row + 1;
            }
            return this.getTransition(row).getTarget().getDefaultLabel();
        }

        public void switchRows(int oldIndex, int newIndex) {
            SequenceFlow oldTransition = this.list.get(oldIndex);
            this.list.remove(oldIndex);
            this.list.add(newIndex, oldTransition);
            this.fireTableDataChanged();
        }
    }
}

