/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import oracle.bpm.draw.Color;
import oracle.bpm.draw.Font;
import oracle.bpm.draw.Graphics;
import oracle.bpm.log.Log;
import oracle.bpm.ui.peer.swing.AwtConverter;

public class TemplateContext
extends StyleContext
implements ViewFactory {
    Font commentFont = Font.MONOSPACED.italic().resize(14);
    JEditorPane pane_d;
    Font plainFont = Font.MONOSPACED.resize(14);
    private String[] reservedList = new String[]{"rem", "not", "and", "or", "is", "in", "null", "true", "false", "this", "super", "do", "end", "if", "display", "input", "then", "else", "elseif", "for", "each", "where", "while", "on", "exit", "when", "using", "returning", "ordered", "use"};
    static final long serialVersionUID = 131927038944334985L;
    static final long serialCheck = -1617960762448417925L;

    TemplateContext() {
    }

    @Override
    public View create(Element elem) {
        return new TemplateView(elem);
    }

    final void setJEditorPane(JEditorPane pane) {
        this.pane_d = pane;
        this.pane_d.setFont(AwtConverter.toAwt((Font)this.plainFont));
    }

    private boolean isReserved(String text) {
        for (int i = 0; i < this.reservedList.length; ++i) {
            if (!this.reservedList[i].equals(text)) continue;
            return true;
        }
        return false;
    }

    final class TemplateView
    extends PlainView {
        TemplateView(Element elem) {
            super(elem);
        }

        public void drawLine(int lineIndex, Graphics g, int x, int y) {
            Document document = this.getDocument();
            Segment line = new Segment();
            Element lineElement = this.getElement().getElement(lineIndex);
            int start = lineElement.getStartOffset();
            int end = lineElement.getEndOffset();
            try {
                String text = document.getText(start, end - (start + 1));
                int length = text.length();
                int i = 0;
                while (i < length && i < end) {
                    int to;
                    int from = i;
                    while (i < length && Character.isWhitespace(text.charAt(i))) {
                        ++i;
                    }
                    if (i < length) {
                        boolean scaped;
                        char firstChar = text.charAt(i);
                        if (Character.isDigit(firstChar)) {
                            g.setForeground(Color.RED.darker());
                            for (to = i + 1; to < length && Character.isDigit(text.charAt(to)); ++to) {
                            }
                        } else if (Character.isLetter(firstChar) || firstChar == '_') {
                            g.setForeground(Color.BLUE.darker());
                            while (to < length && (Character.isLetter(text.charAt(to)) || Character.isDigit(text.charAt(to)) || text.charAt(to) == '_') && !Character.isWhitespace(text.charAt(to))) {
                                ++to;
                            }
                            if (TemplateContext.this.isReserved(text.substring(i, to))) {
                                g.setForeground(Color.CYAN.darker().darker());
                            }
                        } else if (firstChar == '\"' || firstChar == '\'') {
                            g.setForeground(Color.RED.darker());
                            scaped = false;
                            while (to < length && (text.charAt(to) != firstChar || scaped)) {
                                scaped = text.charAt(to) == '\\' && !scaped;
                                ++to;
                            }
                            if (to < length) {
                                ++to;
                            }
                        } else if (firstChar == '{') {
                            g.setForeground(Color.RED.darker().darker());
                            scaped = false;
                            while (to < length && (text.charAt(to) != '}' || scaped)) {
                                scaped = text.charAt(to) == '\\' && !scaped;
                                ++to;
                            }
                            if (to < length) {
                                ++to;
                            }
                        } else if (length - i > 1 && firstChar == '/' && text.charAt(i + 1) == '/') {
                            g.setForeground(Color.DARK_GRAY);
                            g.setFont(TemplateContext.this.commentFont);
                            to = length;
                        } else {
                            g.setForeground(Color.YELLOW.darker());
                        }
                    }
                    document.getText(start + from, to - from, line);
                    if (!TemplateContext.this.pane_d.isEnabled()) {
                        g.setFont(TemplateContext.this.commentFont);
                        g.setForeground(Color.DARK_GRAY);
                    }
                    x = Utilities.drawTabbedText(line, x, y, AwtConverter.toAwt((Graphics)g), (TabExpander)this, start + from);
                    if (g.getFont() == TemplateContext.this.commentFont) {
                        g.setFont(TemplateContext.this.plainFont);
                    }
                    i = to;
                }
            }
            catch (Exception bl) {
                Log.logWarning(bl);
            }
        }
    }
}

