/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Set;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.InputValidationException;
import oracle.bpm.ui.InputValidator;
import oracle.bpm.util.Identifier;

public class TaskNameInputValidator
implements InputValidator {
    private Set<String> otherTasks;

    public TaskNameInputValidator(Set<String> otherTasks) {
        this.otherTasks = otherTasks;
    }

    @Override
    public void validate(String newTaskName) throws InputValidationException {
        if (newTaskName == null) {
            return;
        }
        InputValidationException.assertNotEmpty(newTaskName, DesignerMsg.OBJECT_NAME_CANNOT_BE_EMPTY);
        InputValidationException.assertTrue(TaskNameInputValidator.isNameUniqueness(this.otherTasks, newTaskName), DesignerMsg.TASK_LABEL_ALREADY_EXISTS);
    }

    protected static boolean isNameUniqueness(Set<String> otherTasksNames, String newTaskName) {
        String newIdentifierTaskName = newTaskName;
        return !otherTasksNames.contains(newIdentifierTaskName = Identifier.attribute(newIdentifierTaskName));
    }
}

