/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.StudioEditor;
import oracle.bpm.designer.action.InternalAutoSaveAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lang.LowResolutionTimer;
import oracle.bpm.lang.LowResolutionTimerListener;
import oracle.bpm.log.Log;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.monitor.MonitorDialogWithDelay;
import oracle.bpm.ui.monitor.ProgressDialog;
import oracle.bpm.ui.monitor.ProgressMonitorBuilder;
import oracle.bpm.util.Sequencer;

public class StudioPersistenceThread
extends Thread {
    Sequencer sequencer = new Sequencer();
    LowResolutionTimer timer;

    public StudioPersistenceThread(long delay) {
        this.timer = new LowResolutionTimer((int)(delay / 1000L));
        this.timer.add(new LowResolutionTimerListener(){

            @Override
            public void timerFired(LowResolutionTimer timer) {
                try {
                    StudioPersistenceThread.this.autoSave();
                }
                catch (Throwable throwable) {
                    Log.logSevere(throwable);
                }
            }
        });
    }

    public void autoSave() throws Throwable {
        Sequencer.Job job = this.sequencer.execute(new Runnable(){

            @Override
            public void run() {
                new InternalAutoSaveAction().doIt();
            }
        });
        job.waitFor();
        if (job.getThrowable() != null) {
            Log.logSevere(job.getThrowable());
            throw job.getThrowable();
        }
    }

    public void autoSave(final StudioEditor editor) throws Throwable {
        Sequencer.Job job = this.sequencer.execute(new Runnable(){

            @Override
            public void run() {
                new InternalAutoSaveAction(editor).doIt();
            }
        });
        job.waitFor();
        if (job.getThrowable() != null) {
            Log.logSevere(job.getThrowable());
            throw job.getThrowable();
        }
    }

    public void doCheckpoint() throws Throwable {
        final MonitorDialogWithDelay monitorDialogWithDelay = ProgressMonitorBuilder.createProgressDialogWithDelay((UiWindow)DesignerApplication.getInstance(), (Msg)DesignerMsg.SAVING, (int)500);
        Sequencer.Job job = this.sequencer.execute(new Runnable(){

            @Override
            public void run() {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DesignerApplication.getInstance().getStatusBar().showNotice(DesignerMsg.SAVING);
                    }
                });
                DesignerApplication.getInstance().getStatusBar().clearMessage();
                monitorDialogWithDelay.setVisible(false);
            }
        });
        job.waitFor();
        if (job.getThrowable() != null) {
            Log.logSevere(job.getThrowable());
            throw job.getThrowable();
        }
    }

    public void restoreToSaved() throws Throwable {
        ProgressMonitorBuilder progressBuilder = ProgressMonitorBuilder.createSimpleBuilder();
        final ProgressDialog dialog = progressBuilder.buildProgressDialog((UiWindow)DesignerApplication.getInstance(), DesignerMsg.CLOSING_PROJECT);
        Sequencer.Job job = this.sequencer.execute(new Runnable(){

            @Override
            public void run() {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            DesignerApplication instance = DesignerApplication.getInstance();
                            instance.getStatusBar().showNotice(DesignerMsg.EXECUTING_ROLLBACK);
                            instance.getStatusBar().clearMessage();
                        }
                        finally {
                            dialog.setVisible(false);
                        }
                    }
                });
            }
        });
        job.waitFor();
        if (job.getThrowable() != null) {
            Log.logSevere(job.getThrowable());
            throw job.getThrowable();
        }
    }

    @Override
    public void run() {
        this.timer.start();
    }
}

