/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import oracle.bpm.designer.AbstractTreeNode;
import oracle.bpm.designer.DesignerAction;
import oracle.bpm.designer.StudioTree;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreePath;

public class StructureTree
extends StudioTree {
    private TreeSelectionListener autoScrollListener;
    private boolean editableStructure = true;
    private boolean groupInheritedMembers;
    private PropertyChangeListener languageListener;
    private int modifiers_d = 254;
    private MultipleSelectionPopupProvider multipleProvider = DEFAULT_PROVIDER;
    public static final int METHODS = 2;
    public static final int ATTRIBUTES = 4;
    public static final int PRESENTATIONS = 8;
    public static final int MODULES = 16;
    public static final int USER_MODULES = 32;
    public static final int TRANSFORMS = 64;
    public static final int DEFAULT_MODULES = 128;
    public static final int ALL = 254;
    public static final int ALL_BUT_DEFAULT_MODULES = 126;
    static final long serialVersionUID = 5595468284654749253L;
    static final long serialCheck = 7834401385705219107L;
    private static MultipleSelectionPopupProvider DEFAULT_PROVIDER = new MultipleSelectionPopupProvider(){

        @Override
        public PopupMenu getPopupMenuForSelection(UiContainer parent, TreePath[] paths) {
            return StructureTree.createDefaultMenu(parent);
        }
    };

    public StructureTree() {
        super(null);
    }

    public StructureTree(UiContainer parent) {
        super(parent);
    }

    public StructureTree(UiContainer parent, TreeNode root) {
        super(parent);
        this.setRoot(root);
    }

    public StructureTree(UiContainer parent, boolean editableStructure) {
        super(parent);
        this.editableStructure = editableStructure;
        this.setRoot(new DummyTreeNode());
        this.setSelectionMode(TreeSelectionMode.DISCONTIGUOUS_TREE_SELECTION);
    }

    public boolean isAutoScrollFromSource() {
        return false;
    }

    public void setAutoScrollToSource(boolean autoScrollToSource) {
        this.checkListener(autoScrollToSource);
    }

    public void setGroupInheritedMembers(boolean groupInheritedMembers) {
        if (this.groupInheritedMembers != groupInheritedMembers) {
            this.groupInheritedMembers = groupInheritedMembers;
            this.getRoot().reload();
        }
    }

    public boolean isGroupInheritedMembers() {
        return this.groupInheritedMembers;
    }

    public void setRoot(TreeNode treeNode) {
        super.setRoot(treeNode);
        this.setMultipleSelectionPopupProvider(null);
        this.reload();
    }

    public void setMultipleSelectionPopupProvider(MultipleSelectionPopupProvider multipleSelectionPopupProvider) {
        this.multipleProvider = multipleSelectionPopupProvider == null ? DEFAULT_PROVIDER : multipleSelectionPopupProvider;
    }

    public boolean showAttributes() {
        return this.compliesModifier(4);
    }

    public boolean showPresentations() {
        return this.compliesModifier(8);
    }

    public boolean showMethods() {
        return this.compliesModifier(2);
    }

    protected void buildPopup(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (this.editableStructure && path != null) {
            super.buildPopup(e);
        } else {
            StructureTree.createDefaultMenu(this.getParent()).show((UiComponent)this, e.getX(), e.getY());
        }
    }

    protected void buildMultiplePopup(MouseEvent e) {
        TreePath path = this.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            TreePath[] paths = this.getSelectionPaths();
            if (paths == null || paths.length == 0) {
                this.buildPopup(e);
            } else {
                this.multipleProvider.getPopupMenuForSelection(this.getParent(), paths).show((UiComponent)this.getParent(), e.getX(), e.getY());
            }
        } else {
            StructureTree.createDefaultMenu(this.getParent()).show((UiComponent)this, e.getX(), e.getY());
        }
    }

    protected void deletePressed() {
        if (this.editableStructure) {
            super.deletePressed();
        }
    }

    protected void doubleClick(MouseEvent e) {
        if (this.editableStructure) {
            super.doubleClick(e);
        }
    }

    protected void enterPressed() {
        if (this.editableStructure) {
            super.enterPressed();
        }
    }

    protected void init() {
        super.init();
        this.initDnD();
        this.registerLanguageListener();
    }

    protected void processSelectNode(TreeSelectionEvent e) {
        if (this.editableStructure) {
            super.processSelectNode(e);
        }
    }

    protected void singleClick(MouseEvent e) {
        if (this.editableStructure) {
            super.singleClick(e);
        }
    }

    private static PopupMenu createDefaultMenu(UiContainer parent) {
        return PopupMenu.create((UiContainer)parent, (ActionGroup)new ActionGroup(CoreMsg.NONE));
    }

    private static void doOpen(AbstractTreeNode node) {
        BaseAction openAction = node.getActionForId(2);
        if (openAction instanceof DesignerAction) {
            DesignerAction designerAction = (DesignerAction)openAction;
            designerAction.doIt();
        }
    }

    private boolean compliesModifier(int modifier) {
        return (this.modifiers_d & modifier) != 0;
    }

    private void initDnD() {
        new DragSourceHandler((UiComponent)this, DndAction.COPY_OR_MOVE){
            private DragItem dragItem;
            {
                this.dragItem = null;
            }

            public Transfer[] getTransfers() {
                DragItem nodeDragItem;
                TreeNode node = StructureTree.this.getSelectedTreeNode();
                DragItem dragItem = nodeDragItem = node instanceof DragItem ? (DragItem)node : null;
                if (nodeDragItem != null) {
                    this.dragItem = nodeDragItem;
                }
                return this.dragItem != null ? this.dragItem.getTransfers() : Transfer.NONE;
            }

            public Object getObject(Transfer transfer) {
                return this.dragItem.getObjectAs(transfer);
            }
        };
    }

    private void registerLanguageListener() {
        if (this.languageListener == null) {
            this.languageListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("language".equals(evt.getPropertyName())) {
                        Tree.allNodesChanged((Tree)StructureTree.this);
                    }
                }
            };
            EditorPreferences.getInstance().addListener(this.languageListener);
        }
    }

    private void checkListener(boolean autoScrollToSource) {
        if (this.autoScrollListener == null) {
            this.autoScrollListener = new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    Object node;
                    TreePath p = e.getNewLeadSelectionPath();
                    if (p != null && (node = p.getLastPathComponent()) instanceof AbstractTreeNode) {
                        StructureTree.doOpen((AbstractTreeNode)((Object)node));
                    }
                }
            };
        }
        if (autoScrollToSource) {
            this.addTreeSelectionListener(this.autoScrollListener);
        } else {
            this.removeTreeSelectionListener(this.autoScrollListener);
        }
    }

    static class DummyTreeNode
    extends AbstractTreeNode {
        DummyTreeNode() {
        }

        public Image getIcon() {
            return null;
        }

        public String toString() {
            return "";
        }

        protected Image getImage() {
            return null;
        }
    }

    public static interface MultipleSelectionPopupProvider {
        public PopupMenu getPopupMenuForSelection(UiContainer var1, TreePath[] var2);
    }
}

