/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.CheckBox;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.AttributeType;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.RelativeLayout;

public class StartEngineDialog
extends OkCancelDialog {
    private boolean clearLog;
    private CheckBox clearLogCheckBox;
    private boolean fromScratch;
    private CheckBox fromScratchCheckBox;

    public StartEngineDialog(UiWindow parent, String projectName) {
        super(parent, DesignerMsg.START_ENGINE(projectName), true, true);
        this.init(parent);
    }

    public boolean isClearLog() {
        return this.clearLog;
    }

    public boolean isFromScratch() {
        return this.fromScratch;
    }

    public void ok() {
        this.fromScratch = this.fromScratchCheckBox.isSelected();
        this.clearLog = this.clearLogCheckBox.isSelected();
        DesignerPreferences prefs = DesignerPreferences.getPreferences();
        prefs.setRemoveInstancesWhenStartingEngine(this.fromScratch);
        prefs.setRemoveLogFilesWhenStartingEngine(this.clearLog);
        prefs.setShowEngineOptionsBeforeStart(this.doShowDialogAgain());
        prefs.store();
        this.close();
    }

    private Panel buildCleanInstancesOption(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel panel = new Panel(parent, DesignerMsg.START_CLEAN_ENGINE);
        panel.setLayout((Layout)layout);
        LabelMultiline message = new LabelMultiline((UiContainer)panel, DesignerMsg.START_CLEAN_ENGINE_HELP);
        this.fromScratchCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.START_CLEAN_ENGINE);
        panel.add((UiComponent)message, (Object)"textArea");
        panel.add((UiComponent)this.fromScratchCheckBox, (Object)"checkBox");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.TOP, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.RIGHT, (int)-5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"checkBox", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"checkBox", (AttributeType)AttributeType.TOP, (String)"textArea", (AttributeType)AttributeType.BOTTOM, (int)5);
        return panel;
    }

    private Panel buildCleanLogOption(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel panel = new Panel(parent, DesignerMsg.CLEAR_LOG);
        panel.setLayout((Layout)layout);
        LabelMultiline textArea = new LabelMultiline((UiContainer)panel, DesignerMsg.CLEAR_LOG_HELP);
        this.clearLogCheckBox = CheckBox.create((UiContainer)panel, (Msg)DesignerMsg.CLEAR_LOG);
        panel.add((UiComponent)textArea, (Object)"textArea");
        panel.add((UiComponent)this.clearLogCheckBox, (Object)"checkBox");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.TOP, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"textArea", (AttributeType)AttributeType.RIGHT, (int)-5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"checkBox", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"checkBox", (AttributeType)AttributeType.TOP, (String)"textArea", (AttributeType)AttributeType.BOTTOM, (int)5);
        return panel;
    }

    private Panel buildOptionsPanel(UiContainer parent) {
        RelativeLayout layout = new RelativeLayout();
        Panel panel = Panel.createPanelWithBorder((UiContainer)parent);
        panel.setLayout((Layout)layout);
        panel.add((UiComponent)this.buildCleanInstancesOption((UiContainer)panel), (Object)"cleanInstances");
        panel.add((UiComponent)this.buildCleanLogOption((UiContainer)panel), (Object)"cleanLog");
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"cleanInstances", (AttributeType)AttributeType.TOP, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"cleanInstances", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"cleanInstances", (AttributeType)AttributeType.RIGHT, (int)-5);
        oracle.bpm.ui.utils.Layout.fixToComp((RelativeLayout)layout, (String)"cleanLog", (AttributeType)AttributeType.TOP, (String)"cleanInstances", (AttributeType)AttributeType.BOTTOM, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"cleanLog", (AttributeType)AttributeType.LEFT, (int)5);
        oracle.bpm.ui.utils.Layout.fixToRoot((RelativeLayout)layout, (String)"cleanLog", (AttributeType)AttributeType.RIGHT, (int)-5);
        return panel;
    }

    private void init(UiWindow parent) {
        Panel optionPanel = this.buildOptionsPanel(this.getContentPane());
        this.getContentPane().add((UiComponent)optionPanel, (Object)"Center");
        this.setSize(450, 450);
        this.setLocationRelativeTo((UiComponent)parent);
        DesignerPreferences prefs = DesignerPreferences.getPreferences();
        this.fromScratchCheckBox.setSelected(prefs.removeInstancesWhenStartingEngine());
        this.clearLogCheckBox.setSelected(prefs.removeLogFilesWhenStartingEngine());
        this.revalidate();
    }
}

