/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.io.File;
import oracle.bpm.designer.ProcessPreviewer;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.io.fs.FileProjectRepository;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.algorithms.KoreanLayoutAlgorithm;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.Frame;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiType;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class StandaloneProcessFrame {
    private Process process;
    private Project project;
    private static final String PROJECT_NAME = "TmpProject";

    public StandaloneProcessFrame(@NotNull File baseDir) {
        this.project = this.createTmpProject(baseDir);
        this.process = this.project.findProcess("PhaseManager");
    }

    public static void main(String[] args) {
        StandaloneProcessFrame frame = new StandaloneProcessFrame(new File("/tmp/"));
        frame.visualize();
    }

    private void visualize() {
        Ui.initialize((UiType)UiType.SWING);
        Frame frame = new Frame("Before - After Visual Layout Tester");
        Panel panel = new Panel((UiContainer)frame);
        panel.setLayout((Layout)new BorderLayout());
        final ProcessPreviewer previewer = new ProcessPreviewer((UiContainer)panel){

            @Override
            protected void initDrawContext(Graphics graphics, Rectangle rectangle) {
                super.initDrawContext(graphics, rectangle);
                this.getDrawContext().setScale(1.0f);
            }
        };
        Button button = new Button((UiContainer)panel, new BaseAction(Msg.QUOTE("Run Autolayout!")){

            public void run() {
                try {
                    StandaloneProcessFrame.this.autolayout();
                    previewer.setProcessToRender(StandaloneProcessFrame.this.process);
                    previewer.repaint();
                }
                catch (ProjectException e) {
                    e.printStackTrace();
                }
            }
        });
        previewer.setProcessToRender(this.process);
        Rectangle bounds = previewer.getDrawableProcess().getBounds(previewer.getDrawContext()).expand(8);
        previewer.setSize(bounds.getWidth(), bounds.getHeight());
        panel.add((UiComponent)previewer, (Object)"Center");
        panel.add((UiComponent)button, (Object)"South");
        frame.add((UiComponent)panel);
        frame.pack();
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
    }

    private void autolayout() throws ProjectException {
        KoreanLayoutAlgorithm.layoutModel((NodeContainer)this.process, (int)1, (boolean)DesignerPreferences.getPreferences().isOptimizeLanesOnAutoLayout());
    }

    private Project createTmpProject(@NotNull File baseDir) {
        Project result;
        try {
            result = FileProjectRepository.create((File)baseDir).create(PROJECT_NAME);
        }
        catch (ProjectException e) {
            throw new RuntimeException("Ooooooops, could not create the tmp project!", e);
        }
        return result;
    }
}

