/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Locale;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ParticipantEditorPanel;
import oracle.bpm.designer.ProcessCommunicationEditorPanel;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.selectorpanel.ComboBoxSelectorPanel;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.project.compile.process.ConversationHelper;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessCommunicationEnabled;
import oracle.bpm.project.model.processes.ServiceTask;
import oracle.bpm.resources.I18nProvider;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;

public class ServiceTaskPanel
extends ComboBoxSelectorPanel<ServiceTaskOptions, ServiceTask> {
    public ServiceTaskPanel(@NotNull UiContainer parent, @NotNull ServiceTask projectObject) {
        super(parent, CoreMsg.SERVICE_TASK, projectObject, DesignerMsg.CONVERSATION_IMPLEMENTATION, 5);
        this.init();
    }

    @Override
    public void objectToEditor(ServiceTask projectObject) {
        ServiceTask serviceTask = (ServiceTask)this.getProjectObject();
        if (serviceTask.getAssociatedProcess() != null) {
            this.setSelectedOption(ServiceTaskOptions.PROCESS);
        } else if (serviceTask.getParticipant() != null) {
            this.setSelectedOption(ServiceTaskOptions.SERVICE);
        } else {
            this.setSelectedOption(ServiceTaskOptions.NOT_IMPLEMENTED);
        }
        this.getInnerEditor().objectToEditor(null);
    }

    @Override
    public ServiceTask editorToObject() throws ProjectException {
        ServiceTask serviceTask = (ServiceTask)this.getProjectObject();
        ProjectObjectEditorPanel innerEditor = this.getInnerEditor();
        if (innerEditor != null) {
            innerEditor.editorToObject();
        }
        return serviceTask;
    }

    @Override
    public void validatePanel() throws ProjectException {
        this.getInnerEditor().validatePanel();
    }

    @Override
    protected ProjectObjectEditorPanel createInnerEditor(@NotNull UiContainer container, @NotNull ServiceTaskOptions selectedItem) {
        ProjectObjectEditorPanel result = null;
        switch (selectedItem) {
            case SERVICE: {
                result = new ServiceTaskServiceEditor(container, (ParticipantEnabled)this.getProjectObject(), ParticipantEditorPanel.ServiceEditorServiceType.INVOKE, ParticipantEditorPanel.ServiceEditorSynchronicityType.ALL, ParticipantEditorPanel.ServiceEditorInterfaceType.SERVICE);
                break;
            }
            case PROCESS: {
                result = new ServiceTaskProcessEditor(container, (ServiceTask)this.getProjectObject());
                break;
            }
            case NOT_IMPLEMENTED: {
                result = new ServiceTaskNotImplementedEditor(container, (ServiceTask)this.getProjectObject());
            }
        }
        return result;
    }

    private void init() {
        this.addOption(ServiceTaskOptions.SERVICE);
        this.addOption(ServiceTaskOptions.PROCESS);
        this.addOption(ServiceTaskOptions.NOT_IMPLEMENTED);
        this.setSelectedOption(ServiceTaskOptions.SERVICE);
        this.setLabelProvider(new LabelProvider<ServiceTaskOptions>(){

            public Image getIcon(ServiceTaskOptions element) {
                return element.getIcon();
            }

            public String getText(ServiceTaskOptions element) {
                return element.getString();
            }
        });
    }

    private static class ServiceTaskServiceEditor
    extends ParticipantEditorPanel {
        public ServiceTaskServiceEditor(@NotNull UiContainer parent, @NotNull ParticipantEnabled projectObject, @NotNull ParticipantEditorPanel.ServiceEditorServiceType serviceType, @NotNull ParticipantEditorPanel.ServiceEditorSynchronicityType syncType, @NotNull ParticipantEditorPanel.ServiceEditorInterfaceType interfaceType) {
            super(parent, projectObject, serviceType, syncType, interfaceType);
        }

        @Override
        public ConversationEnabled editorToObject() throws ProjectException {
            ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
            conversationalNode.setAssociatedNode(null);
            super.editorToObject();
            return conversationalNode;
        }
    }

    private static class ServiceTaskProcessEditor
    extends ProcessCommunicationEditorPanel {
        public ServiceTaskProcessEditor(@NotNull UiContainer parent, @NotNull ServiceTask serviceTask) {
            super(parent, (ProcessCommunicationEnabled)serviceTask);
        }

        @Override
        public ConversationEnabled editorToObject() throws ProjectException {
            ConversationEnabled conversationalNode = (ConversationEnabled)this.getProjectObject();
            conversationalNode.setOperation(null);
            super.editorToObject();
            return conversationalNode;
        }

        @Override
        protected Sequence<ConversationEnabled> getNodes() {
            Sequence result = CollectionUtils.emptySequence();
            Process selectedProcess = this.getSelectedProcess();
            if (selectedProcess != null) {
                result = ConversationHelper.getAllInitiatorCatchers((Process)selectedProcess, null);
            }
            return result;
        }
    }

    private static class ServiceTaskNotImplementedEditor
    extends ProjectObjectEditorPanel<ServiceTask> {
        public ServiceTaskNotImplementedEditor(@NotNull UiContainer parent, @NotNull ServiceTask serviceTask) {
            super(parent, serviceTask);
        }

        @Override
        public void objectToEditor(ServiceTask projectObject) {
        }

        @Override
        public ServiceTask editorToObject() throws ProjectException {
            ServiceTask serviceTask = (ServiceTask)this.getProjectObject();
            serviceTask.setOperation(null);
            serviceTask.setAssociatedNode(null);
            return serviceTask;
        }

        @Override
        public void validatePanel() throws ProjectException {
        }
    }

    public static enum ServiceTaskOptions implements I18nProvider
    {
        SERVICE(DesignerMsg.SERVICE_CALL),
        PROCESS(DesignerMsg.PROCESS_CALL),
        NOT_IMPLEMENTED(DesignerMsg.NOT_IMPLEMENTED);

        private Msg msg;

        private ServiceTaskOptions(Msg msg) {
            this.msg = msg;
        }

        @Override
        public String getString() {
            return this.msg.getString();
        }

        @Override
        public String getString(Locale locale) {
            return this.msg.getString(locale);
        }

        public Image getIcon() {
            return Image.create((Msg)this.msg);
        }
    }
}

