/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.TreeMap;
import oracle.bpm.command.Command;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.ActionRunner;
import oracle.bpm.designer.BaseTransitionPropertiesDialog;
import oracle.bpm.designer.ConditionalTransitionPanel;
import oracle.bpm.designer.DesignerApplication;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.ModelerSequenceFlowPropertiesDialog;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.project.SequenceFlowImpl;
import oracle.bpm.project.command.design.CopySequenceFlowCommand;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.exception.ModelException;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.Feature;
import oracle.bpm.project.model.processes.SequenceFlow;
import oracle.bpm.project.model.processes.TransitionType;
import oracle.bpm.project.model.processes.transitions.ConditionalTransitionFeature;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.ChangeEvent;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.layout.CardLayout;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import org.jetbrains.annotations.NotNull;

public class SequenceFlowPropertiesDialog
extends BaseTransitionPropertiesDialog
implements ChangeListener {
    protected Panel conditionNameBasedPanel;
    DesignerApplication application;
    boolean checkOk = false;
    Msg errorMessage;
    boolean modified = false;
    String warningMessage;
    private boolean built = false;
    private CardLayout cardLayout;
    private BaseTransitionPropertiesDialog.TransitionPanel commonPanel;
    private BaseTransitionPropertiesDialog.TransitionPanel descriptionPanel;
    private SequenceFlow original;
    private TreeMap<TransitionType, Panel> panelMap = new TreeMap();
    private TabbedPane tabbedPane;
    private Panel transitionDataPanel;

    protected SequenceFlowPropertiesDialog(SequenceFlow original) {
        super(Ui.getRoot(), true);
        this.setTitle(DesignerMsg.TRANS_PROP.getString());
        this.original = original;
        this.setSequenceFlow(original.copy());
        this.build();
        this.init(this.getSequenceFlow());
        this.enableTypesCombo();
        this.setSize(500, 600);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    public static boolean editProperties(SequenceFlow sequenceFlow) {
        SequenceFlowPropertiesDialog dialog = new SequenceFlowPropertiesDialog(sequenceFlow);
        dialog.setVisible(true);
        return dialog.userAccepted();
    }

    public static BaseTransitionPropertiesDialog createDialog(@NotNull SequenceFlow sequenceFlow) {
        boolean isDeveloper = DesignerMode.isValid(2);
        SequenceFlowPropertiesDialog dialog = isDeveloper ? new SequenceFlowPropertiesDialog(sequenceFlow) : new ModelerSequenceFlowPropertiesDialog(sequenceFlow);
        return dialog;
    }

    public void ok() {
        BaseTransitionPropertiesDialog.TransitionCheckeable panel = this.getCurrentPanel();
        try {
            this.commonPanel.check();
            if (panel != null) {
                panel.check();
            }
        }
        catch (CancelException e) {
            return;
        }
        catch (ProjectException e) {
            MessageDialog.showError((Throwable)e);
            return;
        }
        this.commonPanel.panelToObject();
        if (panel != null) {
            panel.panelToObject();
        }
        this.descriptionPanel.panelToObject();
        ActionRunner.getInstance().run((Command)new CopySequenceFlowCommand(this.getSequenceFlow(), this.original));
        this.close();
    }

    public void stateChanged(ChangeEvent e) {
        this.modified = true;
    }

    public String getHelpId() {
        return this.tabbedPane.getDefaultHelpId();
    }

    @Override
    protected void init(@NotNull SequenceFlow flow) {
        super.init(flow);
        this.descriptionPanel.objectToPanel();
        this.commonPanel.objectToPanel();
        BaseTransitionPropertiesDialog.TransitionCheckeable panel = (BaseTransitionPropertiesDialog.TransitionCheckeable)this.panelMap.get(((SequenceFlowImpl)flow).getTransitionType());
        if (panel != null) {
            panel.objectToPanel();
        }
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                SequenceFlowPropertiesDialog.this.focus();
            }
        });
        this.transitionDataPanel.revalidate();
    }

    protected void focus() {
        if (this.tabbedPane.getSelectedIndex() == 0 || this.getSelectedType() == TransitionType.CONDITIONAL && !this.isNameFieldEmpty()) {
            this.descriptionPanel.focus();
        } else {
            BaseTransitionPropertiesDialog.TransitionCheckeable panel = this.getCurrentPanel();
            if (panel != null) {
                panel.focus();
            }
        }
    }

    protected BaseTransitionPropertiesDialog.TransitionCheckeable getCurrentPanel() {
        return (BaseTransitionPropertiesDialog.TransitionCheckeable)this.cardLayout.getComponent(this.getSelectedType().name());
    }

    @Override
    protected void updateView() {
        BaseTransitionPropertiesDialog.TransitionCheckeable currentPanel = (BaseTransitionPropertiesDialog.TransitionCheckeable)this.panelMap.get(this.getSelectedType());
        if (currentPanel == null) {
            currentPanel = this.addPanelForType(this.getSelectedType());
        }
        if (currentPanel != null) {
            currentPanel.reinit(this.getSequenceFlow());
            this.cardLayout.show((UiContainer)this.transitionDataPanel, this.getSelectedType().name());
            currentPanel.focus();
        }
    }

    ComponentCatalog getTypeRepository() {
        Project project = this.getSequenceFlow().getProject();
        return project != null ? project.getComponentCatalog() : null;
    }

    private void addPanel(TransitionType type, BaseTransitionPropertiesDialog.TransitionPanel panel) {
        this.transitionDataPanel.add((UiComponent)panel, (Object)type.name());
        panel.makeRecyclable();
        if (DesignerMode.isBusinessAnalyst() && !panel.showsInBusinessAnalyst()) {
            panel.setVisible(false);
        }
        if (DesignerMode.isBusinessArchitect() && !panel.showsInBusinessArchitect()) {
            panel.setVisible(false);
        }
        this.transitionDataPanel.revalidate();
        this.panelMap.put(type, (Panel)panel);
    }

    private BaseTransitionPropertiesDialog.TransitionCheckeable addPanelForType(TransitionType type) {
        BaseTransitionPropertiesDialog.TransitionPanel panel = null;
        if (type.isConditional() && !AbstractStudioWorkbench.getInstance().isBusinessAnalyst()) {
            ConditionalTransitionFeature currentFeature = (ConditionalTransitionFeature)this.getSequenceFlow().getFeature(ConditionalTransitionFeature.class);
            ConditionalTransitionFeature copy = ConditionalTransitionFeature.create();
            if (currentFeature == null) {
                currentFeature = copy;
            }
            copy.copyFrom((Feature)currentFeature);
            final BaseTransitionPropertiesDialog.TransitionPanel finalPanel = panel = new ConditionalTransitionPanel((UiContainer)this.transitionDataPanel, this);
            this.addNameFieldListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    finalPanel.updateLayout();
                }
            });
        } else if (type.isUnconditional()) {
            panel = this.buildUnconditionalPanel((UiContainer)this.transitionDataPanel);
        }
        if (panel != null) {
            this.addPanel(type, panel);
        }
        return panel;
    }

    private void build() {
        if (this.built) {
            return;
        }
        this.tabbedPane = new TabbedPane(this.getContentPane());
        this.descriptionPanel = this.buildDescPanel((UiContainer)this.tabbedPane);
        Panel containerPanel = new Panel((UiContainer)this.tabbedPane);
        containerPanel.setLayout((Layout)new BorderLayout());
        this.cardLayout = new CardLayout();
        this.transitionDataPanel = new Panel((UiContainer)containerPanel);
        this.transitionDataPanel.makeRecyclable();
        this.transitionDataPanel.setLayout((Layout)this.cardLayout);
        this.commonPanel = this.buildCommonPanel((UiContainer)containerPanel);
        this.built = true;
        containerPanel.add((UiComponent)this.commonPanel, (Object)"North");
        containerPanel.add((UiComponent)this.transitionDataPanel, (Object)"Center");
        this.tabbedPane.addTab(DesignerMsg.DESCRIPTION, (UiComponent)this.descriptionPanel);
        this.tabbedPane.addTab(DesignerMsg.PROPERTIES, (UiComponent)containerPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                UiUtilities.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SequenceFlowPropertiesDialog.this.focus();
                    }
                });
            }
        });
        this.getContentPane().add((UiComponent)this.tabbedPane, (Object)"Center");
        this.cardLayout.show((UiContainer)this.transitionDataPanel, TransitionType.CONDITIONAL.name());
        containerPanel.revalidate();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    private BaseTransitionPropertiesDialog.TransitionPanel buildUnconditionalPanel(UiContainer parent) {
        return new EmptyPanel(parent);
    }

    static class CancelException
    extends ModelException {
        public CancelException(ProjectObject projectObject) {
            super(projectObject);
        }
    }

    protected static class EmptyPanel
    extends BaseTransitionPropertiesDialog.TransitionPanel {
        protected EmptyPanel(UiContainer parent) {
            super(parent, null);
        }

        @Override
        public void check() throws ProjectException {
        }

        @Override
        public void objectToPanel() {
        }

        @Override
        public boolean panelToObject() {
            return true;
        }
    }
}

