/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Comparator;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.tree.folder.AbstractFolderTreeNode;
import oracle.bpm.designer.tree.folder.TreeNodeFactory;
import oracle.bpm.designer.tree.folder.actions.CreateResourceFolderAction;
import oracle.bpm.designer.tree.folder.actions.ImportResourcesAction;
import oracle.bpm.designer.utils.IconFactory;
import oracle.bpm.project.model.Container;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.ProjectListenerAdapter;
import oracle.bpm.project.model.resources.Resource;
import oracle.bpm.project.model.resources.ResourceObject;
import oracle.bpm.project.model.resources.ResourcesContainer;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.tree.TreeNode;

public class ResourceFolderNode
extends AbstractFolderTreeNode {
    private int allowedContent;
    private boolean loaded;

    public ResourceFolderNode(Container resourcesContainer) {
        super(resourcesContainer);
        this.isContainer = true;
        this.loaded = false;
        this.registerListener();
    }

    public ResourcesContainer getFolderContent() {
        return (ResourcesContainer)this.getContent();
    }

    @Override
    public Image resolveIcon() {
        this.nodeIcon = Image.create((Msg)DesignerMsg.FOLDER);
        return !this.isReadOnly() ? this.nodeIcon : IconFactory.createReadOnly(this.nodeIcon);
    }

    public boolean isLeaf() {
        return false;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void add(TreeNode newChild) {
        super.add(newChild);
    }

    @Override
    public ActionGroup createActions() {
        ActionGroup result = new ActionGroup(DesignerMsg.FOLDER);
        result.addSeparator();
        CreateResourceFolderAction createFolderAction = new CreateResourceFolderAction();
        createFolderAction.setEnabled(!this.isReadOnly());
        result.add((BaseAction)createFolderAction);
        if ((this.getAllowedContent() & 0xE) == 14) {
            ImportResourcesAction importResourcesAction = new ImportResourcesAction();
            importResourcesAction.setEnabled(!this.isReadOnly());
            result.add((BaseAction)importResourcesAction);
        }
        return result;
    }

    @Override
    public boolean delete() {
        return true;
    }

    public int getAllowedContent() {
        return this.allowedContent;
    }

    public void setAllowedContent(int allowedContent) {
        this.allowedContent = allowedContent;
    }

    protected void objectAdded(final ResourceObject webRootObject) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (ResourceFolderNode.this.getUserObject() == webRootObject.getParent()) {
                    TreeNode node = TreeNodeFactory.create(webRootObject, ResourceFolderNode.this);
                    if (node.getParent() != null) {
                        node.getParent().insert(node, (Comparator)ProjectObjectTreeNode.getComparator());
                    } else {
                        ResourceFolderNode.this.insert(node, ProjectObjectTreeNode.getComparator());
                    }
                }
            }
        });
    }

    protected void objectRemoved(final ResourceObject object) {
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                TreeNode child;
                if (ResourceFolderNode.this.getUserObject() == object.getParent() && (child = ResourceFolderNode.this.findTreeNodeByUserObject(object)) != null) {
                    ResourceFolderNode.this.getTree().removeNodeFromParent(child);
                }
            }
        });
    }

    @Override
    protected void onLoading() {
        if (!this.isLoaded()) {
            ResourcesContainer container = (ResourcesContainer)this.getUserObject();
            for (Container resourceObject : container.getContainers()) {
                ResourceFolderNode containerNode = (ResourceFolderNode)TreeNodeFactory.create((ResourceObject)resourceObject, this);
                containerNode.setAllowedContent(this.getAllowedContent());
                this.add(containerNode);
            }
            for (Resource resource : container.getResources()) {
                TreeNode node = TreeNodeFactory.create((ResourceObject)resource, this);
                this.add(node);
            }
            this.setLoaded(true);
        }
    }

    private void registerListener() {
        this.getProject().addListener((ProjectListener)new ResourceListener());
    }

    private class ResourceListener
    extends ProjectListenerAdapter<ResourceObject> {
        public ResourceListener() {
            super(ResourceObject.class);
        }

        public void postObjectAdded(ResourceObject resourceObject, ProjectObject parent) {
            if (ResourceFolderNode.this.isLoaded()) {
                ResourceFolderNode.this.objectAdded(resourceObject);
            }
        }

        public void postObjectRemoved(ResourceObject resourceObject, ProjectObject parent) {
            ResourceFolderNode.this.objectRemoved(resourceObject);
        }

        public void objectChanged(ResourceObject resourceObject, ProjectEvent event) {
        }
    }
}

