/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.PropertyPropertyTable;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.observers.ObjectPropertyListener;
import oracle.bpm.ui.prop.Property;

public class PropertyTableListener
implements ObjectPropertyListener {
    private Property descriptionProperty;
    private Property presentationProperty;
    private PropertyPropertyTable table;

    public PropertyTableListener(PropertyPropertyTable table) {
        this.table = table;
    }

    public void setPresentationProperty(Property presentation) {
        this.presentationProperty = presentation;
    }

    public void setDescriptionProperty(Property descriptionProperty) {
        this.descriptionProperty = descriptionProperty;
    }

    @Override
    public void propertyChanged(Object object, String propertyName) {
        if ("defaultPresentation".equals(propertyName)) {
            this.updateDefaultPresentation(object);
        }
        if ("description".equals(propertyName)) {
            this.updateDescription(object);
        }
    }

    private void updateDescription(Object object) {
        ObjectTypeDescription typeDescription = (ObjectTypeDescription)object;
        String description = typeDescription.getDescription();
        if (description != null && !this.descriptionProperty.getValue().equals(description)) {
            this.descriptionProperty.updateValue((Object)description);
            this.table.refresh(this.descriptionProperty);
        }
    }

    private void updateDefaultPresentation(Object object) {
        XObjectTypeDescription typeDescription = (XObjectTypeDescription)object;
        String description = typeDescription.getDefaultPresentationName();
        Object value = this.presentationProperty.getValue();
        if (description != null && value != null && !value.equals(description)) {
            this.presentationProperty.updateValue((Object)description);
            this.table.refresh(this.presentationProperty);
        }
    }
}

