/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.bpm.designer.InheritanceComboListener;
import oracle.bpm.designer.PropertyTableListener;
import oracle.bpm.designer.action.InheritAction;
import oracle.bpm.designer.cileditor.SuperTypeProperty;
import oracle.bpm.designer.cileditor.TypeProperty;
import oracle.bpm.designer.formdesigner.XFormSelection;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.designer.properties.MethodPropertyTablePanel;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.ComponentType;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.Platform;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.observers.ObjectRelationListener;
import oracle.bpm.project.CatalogObjectImpl;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.TypeFactory;
import oracle.bpm.type.TypeRef;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.prop.AbstractProperty;
import oracle.bpm.ui.prop.Factory;
import oracle.bpm.ui.prop.Property;
import oracle.bpm.ui.prop.PropertyGroup;
import oracle.bpm.ui.prop.PropertyTable;
import oracle.bpm.ui.prop.PropertyTablePanel;
import oracle.bpm.ui.prop.impl.BooleanProperty;
import oracle.bpm.ui.prop.impl.ComboProperty;
import oracle.bpm.ui.prop.impl.MultiProperty;
import oracle.bpm.ui.prop.impl.TextProperty;
import oracle.bpm.ui.selection.Selection;
import oracle.bpm.ui.selection.SelectionListener;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.xobject.lib.XObjectTypeDescriptionHelper;

public class PropertyPropertyTable
extends PropertyTable
implements SelectionListener {
    private Selection currentSelection = null;
    private TypeDescription lastBaseType;
    private PresentationObjectListener presentationObjectListener;
    private PropertyTableListener typeDescriptionListener;

    public PropertyPropertyTable(UiContainer parent, SelectionProvider provider) {
        super(parent, provider);
    }

    public static SuperType[] getSuperTypes(ObjectTypeDescription object) {
        SuperType[] superTypes = new SuperType[2];
        for (SuperType superType : object.getSuperTypes()) {
            TypeDescription type = superType.getType();
            if (superType.isHidden()) continue;
            if (superTypes[0] == null && superType.isDelegated()) {
                superTypes[0] = superType;
                continue;
            }
            if (superTypes[1] == null && SuperTypeProperty.isImplementable(type)) {
                superTypes[1] = superType;
            }
            if (superTypes[0] == null || superTypes[1] == null) continue;
            break;
        }
        return superTypes;
    }

    public void selectionChanged(Selection selection) {
        if (!selection.equals(this.currentSelection)) {
            this.update(selection);
        }
    }

    public void clearAll() {
        this.removeListeners();
        super.clearAll();
    }

    protected void addXOProperties(ObjectTypeDescription object, PropertyGroup group) {
        boolean isBPMO = ComponentType.XOBJECT.getText().equals(object.getComponentType());
        TypeProperty nameProperty = new TypeProperty(ProjectDrawMsg.NAME, object);
        nameProperty.setEditable(false);
        group.add((Property)nameProperty);
        Property createDescriptionProperty = this.createDescriptionProperty(object);
        createDescriptionProperty.setEditable(isBPMO);
        group.add(createDescriptionProperty);
        BooleanProperty runsOnClient = Factory.createBoolean((Msg)DesignerMsg.RUNS_ON_CLIENT, (boolean)object.isRemote());
        runsOnClient.setEditable(false);
        group.add((Property)runsOnClient);
        if (object.isBpmObject() && ((XObjectTypeDescription)object).isPresentable()) {
            Property createPresentationProperty = this.createPresentationProperty(object);
            createPresentationProperty.setEditable(isBPMO);
            group.add(createPresentationProperty);
        }
        Property createComparableProperty = this.createComparableProperty(object);
        createComparableProperty.setEditable(isBPMO);
        group.add(createComparableProperty);
        Property createAbstractProperty = this.createAbstractProperty(object);
        createAbstractProperty.setEditable(isBPMO);
        group.add(createAbstractProperty);
        for (Property property : this.getInheritanceProperties(object)) {
            property.setEditable(isBPMO);
            group.add(property);
        }
    }

    protected Property createDescriptionProperty(final ObjectTypeDescription objectTypeDesc) {
        TextProperty descriptionProperty = Factory.createText((Msg)DesignerMsg.DESCRIPTION, (String)objectTypeDesc.getDescription());
        descriptionProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                objectTypeDesc.removePropertyObserver("description", PropertyPropertyTable.this.getTypeDescriptionListener());
                objectTypeDesc.setDescription((String)evt.getNewValue());
                objectTypeDesc.addPropertyObserver("description", PropertyPropertyTable.this.getTypeDescriptionListener());
            }
        });
        objectTypeDesc.removePropertyObserver("description", this.getTypeDescriptionListener());
        this.getTypeDescriptionListener().setDescriptionProperty((Property)descriptionProperty);
        objectTypeDesc.addPropertyObserver("description", this.getTypeDescriptionListener());
        return descriptionProperty;
    }

    private PresentationObjectListener getPresentationObjectListener() {
        if (this.presentationObjectListener == null) {
            this.presentationObjectListener = new PresentationObjectListener();
        }
        return this.presentationObjectListener;
    }

    private void refresh(Selection selection) {
        if (selection.equals(this.currentSelection)) {
            this.update(selection);
        }
    }

    private void update(Selection selection) {
        this.clearAll();
        boolean result = this.checkAttribute(selection);
        result = result || this.checkMethod(selection);
        result = result || this.checkPresentation(selection);
        result = result || this.checkFObject(selection);
        this.build();
        this.currentSelection = selection;
    }

    private void removeListeners() {
        if (this.currentSelection != null) {
            this.removePresentationListener(this.currentSelection);
        }
    }

    private PropertyTableListener getTypeDescriptionListener() {
        if (this.typeDescriptionListener == null) {
            this.typeDescriptionListener = new PropertyTableListener(this);
        }
        return this.typeDescriptionListener;
    }

    private void updateMethodProperties(MethodTypeDescription member) {
        if (member.isTransformation()) {
            return;
        }
        TypeDescription parent = member.getParent();
        if (parent != null && parent.isInnerType()) {
            PropertyTablePanel propertyPanel = this.addPropertyTablePanel(DesignerMsg.GROUP_PROPERTIES);
            this.addXOProperties(parent.asObject(), propertyPanel.getGroup());
        }
        this.addPropertyTablePanel(new MethodPropertyTablePanel((UiContainer)this, member));
    }

    private boolean checkFObject(Selection selection) {
        boolean isObject;
        ObjectTypeDescription otd = this.selectionToOTD(selection);
        boolean bl = isObject = otd != null;
        if (isObject) {
            this.updateComponentProperties(otd);
        }
        return isObject;
    }

    private ObjectTypeDescription selectionToOTD(Selection selection) {
        CatalogObjectImpl catalogObject = (CatalogObjectImpl)selection.as(CatalogObjectImpl.class);
        return catalogObject != null ? (ObjectTypeDescription)catalogObject.getDelegate().get() : (ObjectTypeDescription)selection.as(ObjectTypeDescription.class);
    }

    private void updateComponentProperties(ObjectTypeDescription objectSelection) {
        this.addXOProperties(objectSelection, this.addPropertyTablePanel(DesignerMsg.COMPONENT_PROPERTIES).getGroup());
    }

    private boolean checkPresentation(Selection selection) {
        boolean isPresentation;
        List<XFormSelection> presentationSelection = this.asPresentationSelection(selection);
        boolean bl = isPresentation = !presentationSelection.isEmpty();
        if (isPresentation) {
            XFormSelection firstElement = presentationSelection.get(0);
            firstElement.refreshProperties(this, presentationSelection);
            this.addPresentationListener(selection, firstElement);
        }
        return isPresentation;
    }

    private List<XFormSelection> asPresentationSelection(Selection selection) {
        List presentationSelection = selection.asList(XFormSelection.class);
        boolean isPresentation = presentationSelection != null && !presentationSelection.contains(null) && !presentationSelection.isEmpty();
        return isPresentation ? presentationSelection : new ArrayList();
    }

    private void addPresentationListener(Selection selection, XFormSelection xFormSelection) {
        ObjectTypeDescription otd = Platform.getAdapterService().adaptTo(xFormSelection.getSelection(), ObjectTypeDescription.class);
        if (otd != null) {
            this.getPresentationObjectListener().setSelection(selection);
            otd.addRelationObserver("members", this.getPresentationObjectListener());
        }
    }

    private void removePresentationListener(Selection selection) {
        List<XFormSelection> presentationSelection = this.asPresentationSelection(selection);
        if (!presentationSelection.isEmpty()) {
            XFormSelection firstElement = presentationSelection.get(0);
            ObjectTypeDescription otd = Platform.getAdapterService().adaptTo(firstElement.getSelection(), ObjectTypeDescription.class);
            if (otd != null) {
                otd.removeRelationObserver("members", this.getPresentationObjectListener());
            }
        }
    }

    private boolean checkMethod(Selection selection) {
        boolean isMethod;
        MethodTypeDescription methodSelection = (MethodTypeDescription)selection.as(MethodTypeDescription.class);
        boolean bl = isMethod = methodSelection != null && selection.as(AttributeTypeDescription.class) == null;
        if (isMethod) {
            this.updateMethodProperties(methodSelection);
        }
        return isMethod;
    }

    private boolean checkAttribute(Selection selection) {
        boolean isAttribute;
        AttributeTypeDescription attributeSelection = (AttributeTypeDescription)selection.as(AttributeTypeDescription.class);
        boolean bl = isAttribute = attributeSelection != null;
        if (isAttribute) {
            this.updateAttributeProperties(attributeSelection);
        }
        return isAttribute;
    }

    private void updateAttributeProperties(AttributeTypeDescription attribute) {
        this.updateComponentProperties((ObjectTypeDescription)attribute.getParent());
        ObjectTypeDescription innerType = null;
        if (attribute.getParent().isInnerType()) {
            innerType = attribute.getParent().asObject();
        } else if (XObjectTypeDescriptionHelper.isGroup((AttributeTypeDescription)attribute)) {
            innerType = attribute.getResultType().getElementType().asObject();
        }
        if (innerType != null) {
            this.addXOProperties(innerType, this.addPropertyTablePanel(DesignerMsg.GROUP_PROPERTIES).getGroup());
        }
    }

    private Property createAbstractProperty(final ObjectTypeDescription object) {
        BooleanProperty abstractProperty = Factory.createBoolean((Msg)DesignerMsg.ABSTRACT, (boolean)object.isAbstract());
        abstractProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                long oldModifiers = object.getModifiers();
                long newModifiers = Modifier.setAbstract(oldModifiers, (Boolean)evt.getNewValue());
                object.setModifiers(newModifiers);
            }
        });
        return abstractProperty;
    }

    private Property createComparableProperty(final ObjectTypeDescription object) {
        boolean isComparable = Modifier.isComparable(object.getModifiers());
        BooleanProperty comparable = Factory.createBoolean((Msg)DesignerMsg.COMPARABLE, (boolean)isComparable);
        comparable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                long newModifiers = Modifier.setComparable(object.getModifiers(), (Boolean)evt.getNewValue());
                object.setModifiers(newModifiers);
            }
        });
        return comparable;
    }

    private Property createPresentationProperty(ObjectTypeDescription object) {
        final XObjectTypeDescription xo = (XObjectTypeDescription)object;
        Vector<String> vector = new Vector<String>(Arrays.asList(xo.getPresentationNames()));
        ComboProperty presentation = Factory.createCombo((Msg)DesignerMsg.DEFAULT_PRESENTATION_PROPERTY, vector, (Object)xo.getDefaultPresentationName());
        presentation.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                xo.setDefaultPresentationName((String)evt.getNewValue());
            }
        });
        xo.removePropertyObserver("defaultPresentation", this.getTypeDescriptionListener());
        this.getTypeDescriptionListener().setPresentationProperty((Property)presentation);
        xo.addPropertyObserver("defaultPresentation", this.getTypeDescriptionListener());
        return presentation;
    }

    private Property[] getInheritanceProperties(final ObjectTypeDescription object) {
        Vector<Msg> inheritTypeVector = new Vector<Msg>();
        inheritTypeVector.add(LibMsg.INHERITANCE_TYPE_NONE);
        inheritTypeVector.add(DesignerMsg.INHERIT_BEHAVIOUR);
        inheritTypeVector.add(CoreMsg.TYPE);
        ComboProperty inheritanceTypeProperty = Factory.createCombo((Msg)DesignerMsg.INHERITANCE_TYPE, inheritTypeVector, (int)0);
        TextProperty noneProperty = Factory.createText((Msg)DesignerMsg.NO_INHERITANCE_PROPERTY, (String)"");
        noneProperty.setEditable(false);
        SuperType[] superTypes = PropertyPropertyTable.getSuperTypes(object);
        superTypes.toString();
        SuperType delegate = superTypes[0];
        SuperType iface = superTypes[1];
        if (iface != null) {
            this.lastBaseType = iface.getType();
        }
        if (delegate == null) {
            delegate = new SuperType(TypeFactory.getNone(), 0x808000L);
            object.addSuperType(delegate);
        }
        SuperTypeProperty delegateProperty = SuperTypeProperty.createDelegateProperty(delegate, object);
        if (iface == null) {
            iface = new SuperType(TypeFactory.getNone(), 32768L);
            iface.setParent(object);
        }
        SuperTypeProperty ifaceProperty = SuperTypeProperty.createImplementProperty(iface, object);
        final SuperType ifaceSuperType = iface;
        ifaceProperty.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                TypeDescription newSuperType;
                boolean found = false;
                for (SuperType superType : object.getSuperTypes()) {
                    if (superType != ifaceSuperType) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    if (ifaceSuperType.getType() != TypeFactory.getNone()) {
                        object.addSuperType(ifaceSuperType);
                    }
                } else if (ifaceSuperType.getType() == TypeFactory.getNone()) {
                    object.removeSuperType(ifaceSuperType);
                }
                if ((newSuperType = ifaceSuperType.getType()) != PropertyPropertyTable.this.lastBaseType && newSuperType != TypeFactory.getNone()) {
                    new InheritAction(CatalogObjectImpl.create((TypeRef)newSuperType), CatalogObjectImpl.create((TypeRef)object)).doIt();
                }
                PropertyPropertyTable.this.lastBaseType = ifaceSuperType.getType();
            }
        });
        MultiProperty valueProperty = new MultiProperty(0, new AbstractProperty[]{noneProperty, delegateProperty, ifaceProperty}){

            public void setEditorValue(Object newValue) {
                SuperTypeProperty superTypeProperty = (SuperTypeProperty)this.getCurrent();
                superTypeProperty.setEditorValue(newValue);
            }
        };
        inheritanceTypeProperty.addPropertyChangeListener((PropertyChangeListener)new InheritanceComboListener(inheritTypeVector, valueProperty));
        if (TypeFactory.getNone() != delegate.getType()) {
            inheritanceTypeProperty.setValue((Object)inheritTypeVector.get(1));
            valueProperty.changeCurrent(1);
        } else if (TypeFactory.getNone() != iface.getType()) {
            inheritanceTypeProperty.setValue((Object)inheritTypeVector.get(2));
            valueProperty.changeCurrent(2);
        }
        return new Property[]{inheritanceTypeProperty, valueProperty};
    }

    private class PresentationObjectListener
    implements ObjectRelationListener {
        private Selection selection;

        private PresentationObjectListener() {
        }

        public void setSelection(Selection selection) {
            this.selection = selection;
        }

        @Override
        public void relationAdded(Object object, String relationName) {
            this.update();
        }

        @Override
        public void relationRemoved(Object object, String relationName) {
            this.update();
        }

        private void update() {
            if (this.selection != null) {
                PropertyPropertyTable.this.refresh(this.selection);
            }
        }
    }
}

