/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.net.URL;
import java.util.Comparator;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.controller.SequenceFlowController;
import oracle.bpm.lang.Platform;
import oracle.bpm.project.model.Localizable;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.ui.tree.TreeNode;

public class ProjectObjectTreeNodeComparator
implements Comparator<TreeNode> {
    @Override
    public int compare(TreeNode o1, TreeNode o2) {
        Object element1 = ((ProjectObjectTreeNode)o1).getProjectObject();
        Object element2 = ((ProjectObjectTreeNode)o2).getProjectObject();
        assert (element1 != null && element2 != null);
        int result = this.compareObjects((ProjectObject)element1, (ProjectObject)element2);
        if (result == 0) {
            result = this.compareNames((ProjectObject)element1, (ProjectObject)element2);
        }
        if (result == 0 && element1 != element2) {
            System.out.println("ProjectObjectTreeNodeComparator ERROR: " + element1 + " [" + element1.getClass() + "] != " + element2 + " [" + element2.getClass() + "]");
        }
        return result;
    }

    private int getComparison(ProjectObject element1, ProjectObject element2) {
        if (element1 instanceof FlowNode) {
            FlowNode fuegoNode = (FlowNode)element1;
            if (ModelUtils.isStartEvent((FlowNode)fuegoNode)) {
                return -1;
            }
            if (ModelUtils.isEndEvent((FlowNode)fuegoNode)) {
                return 1;
            }
            if (element2 instanceof SequenceFlowController) {
                return -1;
            }
        }
        return Integer.valueOf(element1.getPosition()).compareTo(element2.getPosition());
    }

    private int compareObjects(ProjectObject element1, ProjectObject element2) {
        int result = this.getComparison(element1, element2);
        if (result == 0) {
            result = -1 * this.getComparison(element2, element1);
        }
        return result;
    }

    private int compareNames(ProjectObject element1, ProjectObject element2) {
        String label1 = this.getLabel(element1);
        String label2 = this.getLabel(element2);
        int result = 0;
        if (label1 != null && label2 != null) {
            result = label1.compareTo(label2);
        }
        if (result == 0 && element1 != element2) {
            String id1 = this.getId(element1);
            String id2 = this.getId(element2);
            result = id1.compareTo(id2);
        }
        return result;
    }

    private String getLabel(ProjectObject element) {
        String label = null;
        if (element instanceof Localizable) {
            Localizable localizable = (Localizable)element;
            label = localizable.getDefaultLabel();
        }
        return label;
    }

    private String getId(ProjectObject element) {
        String id = element.getId();
        if (id == null) {
            id = "";
        }
        id = id + element.toString();
        id = id + Platform.getAdapterService().adaptTo(element, URL.class);
        id = id + System.identityHashCode(element);
        return id;
    }
}

