/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.Comparator;
import java.util.List;
import oracle.bpm.designer.AbstractTreeNode;
import oracle.bpm.designer.ProjectObjectIcon;
import oracle.bpm.designer.ProjectObjectTreeNodeComparator;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.project.view.renderer.ProjectObjectRenderer;
import oracle.bpm.ui.Image;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;

public abstract class ProjectObjectTreeNode<E extends ProjectObject>
extends AbstractTreeNode {
    protected Image cachedIcon;
    private ProjectFilter filter;
    private static ProjectObjectTreeNodeComparator comparator;

    public ProjectObjectTreeNode(ProjectObject element) {
        assert (element != null) : "Element cannot be null";
        this.setUserObject(element);
    }

    public static ProjectObjectTreeNodeComparator getComparator() {
        if (comparator == null) {
            comparator = new ProjectObjectTreeNodeComparator();
        }
        return comparator;
    }

    public void reloadIcon() {
        this.cachedIcon = null;
    }

    public Image getIcon() {
        if (this.cachedIcon == null) {
            Image icon = this.resolveIcon();
            this.cachedIcon = icon != null ? ProjectObjectIcon.create(this.getUserObject(), this.resolveIcon()) : null;
        }
        return this.cachedIcon;
    }

    public Image resolveIcon() {
        return ProjectObjectRenderer.Default.getIcon(this.getProjectObject());
    }

    public ProjectFilter getFilter() {
        if (this.filter == null) {
            TreeNode parent = this.getParent();
            if (parent instanceof ProjectObjectTreeNode) {
                this.filter = ((ProjectObjectTreeNode)parent).getFilter();
            }
            if (this.filter == null) {
                this.filter = new DefaultProjectFilter();
            }
        }
        return this.filter;
    }

    public void setFilter(ProjectFilter filter) {
        this.filter = filter;
        if (this.isLoaded()) {
            List children = this.getChildren();
            for (TreeNode child : children) {
                ((ProjectObjectTreeNode)child).setFilter(filter);
            }
        }
    }

    public E getProjectObject() {
        return (E)((ProjectObject)super.getUserObject());
    }

    public E getUserObject() {
        return (E)((ProjectObject)super.getUserObject());
    }

    public <V extends ProjectObject> ProjectObjectTreeNode<V> find(V object) {
        Iterable iterable = this.postorder();
        for (TreeNode treeNode : iterable) {
            if (treeNode.getUserObject() != object) continue;
            return (ProjectObjectTreeNode)treeNode;
        }
        return null;
    }

    public BaseAction getOpenAction() {
        return null;
    }

    public Project getProject() {
        return this.getProjectObject().getProject();
    }

    public void doubleClick(MouseEvent e) {
        BaseAction action = this.getOpenAction();
        if (action == null) {
            action = new OpenObjectAction(this.getUserObject());
        }
        action.runWithSelection(this.getUserObject());
    }

    public void insertSorted(TreeNode newChild) {
        Tree tree = this.getTree();
        tree.insertSortedNode(newChild, (TreeNode)this, (Comparator)ProjectObjectTreeNode.getComparator(), false);
    }

    public void doSafeOpen() {
        BaseAction openAction = this.getOpenAction();
        if (openAction != null) {
            openAction.runWithSelection(this.getUserObject());
        }
    }

    public String toString() {
        return ProjectObjectRenderer.Default.getLabel(this.getProjectObject());
    }

    public String getToolTipText() {
        return this.toString();
    }

    protected void onLoading() {
        this.build();
    }

    private void build() {
        if (this.getUserObject() instanceof ProjectObjectContainer) {
            ProjectObjectContainer projectObjectContainer = (ProjectObjectContainer)this.getUserObject();
            ProjectFilter filter = this.getFilter();
            for (ProjectObject child : filter.getChildren(projectObjectContainer)) {
                this.addDynamic(child, ProjectObjectTreeNode.getComparator());
            }
        }
    }
}

