/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.project.model.ProjectObjectType;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.text.ValidFileTextField;

public class ProjectObjectNameDialog
extends OkCancelDialog {
    private String name;
    private ValidFileTextField nameField;
    private ProjectObjectType projectObjectType;

    public ProjectObjectNameDialog(UiWindow parent, ProjectObjectType projectObjectType, String initialName) {
        super(parent, projectObjectType.getMsg());
        this.projectObjectType = projectObjectType;
        this.buildUI(initialName);
    }

    public ProjectObjectType getProjectObjectType() {
        return this.projectObjectType;
    }

    public String getObjectName() {
        return this.name;
    }

    public void ok() {
        this.setObjectName(this.nameField.getText());
        this.close();
    }

    private static ValidFileTextField createInput(UiContainer parent, String currentString) {
        ValidFileTextField nameInput = new ValidFileTextField(parent, 128);
        nameInput.setText(currentString);
        nameInput.setColumns(35);
        nameInput.setSelectionStart(0);
        nameInput.setSelectionEnd(nameInput.getText().length());
        return nameInput;
    }

    private void setObjectName(String name) {
        this.name = name;
    }

    private void buildUI(String initialName) {
        this.setResizable(false);
        String colSpecs = "5dlu, 5dlu, pref, 5dlu, pref:grow, min, 5dlu";
        String rowSpecsHelp = "";
        String rowSpecs = rowSpecsHelp + "5dlu,  pref, 5dlu, pref, 5dlu";
        Panel container = new Panel(this.getContentPane());
        FormLayout layout = new FormLayout(colSpecs, rowSpecs);
        PanelBuilder builder = layout.createBuilder(container);
        CellConstraints cc = layout.createCellConstraints();
        this.nameField = ProjectObjectNameDialog.createInput((UiContainer)container, initialName);
        int y = 2;
        builder.add((UiComponent)Label.create((UiContainer)container, (Msg)UIMsg.NAME), cc.xy(3, y));
        builder.add((UiComponent)this.nameField, cc.xywh(5, y, 2, 1));
        this.getContentPane().add((UiComponent)container, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
        this.nameField.requestFocus();
    }
}

