/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.ProjectObjectPanelCustomConfiguration;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.Transactable;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;

public abstract class ProjectObjectEditorDialog<E extends ProjectObject>
extends OkCancelDialog {
    private ProjectObjectPanelCustomConfiguration custonConfiguration;
    private ProjectObjectEditorPanel<E> editor;
    private String oldId;

    public ProjectObjectEditorDialog(UiWindow parent, Msg title) {
        super(parent, title, true);
    }

    public abstract ProjectObjectEditorPanel<E> buildEditor(UiContainer var1, E var2);

    public abstract void save(E var1) throws ProjectException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ok() {
        this.setUserAccepted(true);
        try {
            this.editor.validatePanel();
            Transactable po = (Transactable)this.editor.getProjectObject();
            try {
                po.beginTransaction();
                E projectObject = this.editor.editorToObject();
                this.save(projectObject);
            }
            finally {
                po.endTransaction();
            }
            this.close();
        }
        catch (ProjectException e) {
            Msg msg = e.getKey();
            if (msg != null) {
                MessageDialog.showError((UiContainer)this, (Msg)msg);
            }
            MessageDialog.showError((UiContainer)this, (Throwable)e);
        }
    }

    protected void init(E projectObject) {
        UiContainer parent = this.getContentPane();
        this.oldId = projectObject.getId();
        this.editor = this.buildEditor(parent, projectObject);
        this.editor.objectToEditor(projectObject);
        parent.add(this.editor, (Object)"Center");
        this.pack();
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }
}

