/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.factory.CollectionFactory;
import oracle.bpm.designer.AbstractStudioWorkbench;
import oracle.bpm.designer.AbstractTreeNode;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.ProjectObjectTreeModel;
import oracle.bpm.designer.ProjectObjectTreeNode;
import oracle.bpm.designer.ProjectTreeNode;
import oracle.bpm.designer.ProjectsTreeNode;
import oracle.bpm.designer.StudioTree;
import oracle.bpm.designer.action.ActionBindingMap;
import oracle.bpm.designer.action.MultipleAction;
import oracle.bpm.designer.preferences.DesignerPreferences;
import oracle.bpm.designer.utils.ClassUtils;
import oracle.bpm.editor.EditorPreferences;
import oracle.bpm.geom.Point;
import oracle.bpm.project.model.FolderContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.ProjectRepository;
import oracle.bpm.project.model.RepositoryAdapter;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.events.ProjectListener;
import oracle.bpm.project.model.events.RepositoryListener;
import oracle.bpm.project.model.organization.Role;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.ui.PopupMenu;
import oracle.bpm.ui.TreeSelectionMode;
import oracle.bpm.ui.Ui;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.dnd.DndAction;
import oracle.bpm.ui.dnd.DragItem;
import oracle.bpm.ui.dnd.DragSourceHandler;
import oracle.bpm.ui.dnd.DropItem;
import oracle.bpm.ui.dnd.DropTargetHandler;
import oracle.bpm.ui.dnd.FileTransfer;
import oracle.bpm.ui.dnd.LocalObjectTransfer;
import oracle.bpm.ui.dnd.Transfer;
import oracle.bpm.ui.event.ActionEvent;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.TreeSelectionEvent;
import oracle.bpm.ui.event.TreeSelectionListener;
import oracle.bpm.ui.tree.Tree;
import oracle.bpm.ui.tree.TreeNode;
import oracle.bpm.ui.tree.TreeNodeVisitor;
import oracle.bpm.ui.tree.TreePath;

public class ProjectNavigatorTree
extends StudioTree {
    private boolean autoScrollFromSource;
    private TreeSelectionListener autoScrollListener;
    private ProjectFilter filter;
    private PropertyChangeListener languageListener;
    private boolean processUserEvents = true;
    private ProjectListener<ProjectObject> projectListener;
    private ProjectListener<ProjectObject> projectListenerDelegate;
    private ProjectRepository projectRepository;
    private RepositoryListener repositoryListener;
    private ProjectObject root;
    private boolean showMenues_d = true;
    private boolean showProjectInherited = false;
    private static ProjectNavigatorTree mainTree;

    public ProjectNavigatorTree(UiContainer parent, ProjectObject root, ProjectFilter filter, boolean rootVisible) {
        super(parent);
        this.root = root;
        this.filter = filter;
        ProjectObjectTreeNode rootNode = (ProjectObjectTreeNode)TreeNode.createDynamic((Object)root);
        rootNode.setFilter(filter);
        this.setRoot(rootNode);
        this.setRootVisible(rootVisible);
        this.setShowsRootHandles(true);
        this.initDnD();
        this.reload();
    }

    private ProjectNavigatorTree(UiContainer parent, ProjectsTreeNode root, int modifiers, ProjectRepository repository) {
        super(parent, modifiers);
        this.setProjectRepository(repository);
        this.setRoot(root);
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.initDnD();
    }

    public static ProjectNavigatorTree createForSingleProject(UiContainer parent, Project project, ProjectFilter filter) {
        return new ProjectNavigatorTree(parent, (ProjectObject)project, filter, true);
    }

    public static ProjectNavigatorTree create(UiContainer parent, ProjectFilter filter, ProjectRepository repository) {
        ProjectsTreeNode root = new ProjectsTreeNode(filter);
        ProjectNavigatorTree projectTree = new ProjectNavigatorTree(parent, root, ProjectNavigatorTree.getProjectTreeTypesFilter(), repository);
        root.setTree((Tree)projectTree);
        projectTree.registerLanguageListener();
        projectTree.setSelectionMode(TreeSelectionMode.DISCONTIGUOUS_TREE_SELECTION);
        projectTree.putClientProperty("Tree.lineStyle", "Angled");
        projectTree.setShowsRootHandles(Ui.isFusion());
        projectTree.setRootVisible(Ui.isFusion());
        projectTree.reload();
        return projectTree;
    }

    public static ProjectNavigatorTree getMainTree() {
        return mainTree;
    }

    public static ProjectTreeNode getTreeNodeFor(Project project) {
        if (ProjectNavigatorTree.getMainTree() != null) {
            ProjectObjectTreeNode root = ProjectNavigatorTree.getMainTree().getRoot();
            for (TreeNode treeNode : root.getChildren()) {
                ProjectTreeNode rootNode;
                Project actualProject;
                if (!(treeNode instanceof ProjectTreeNode) || (actualProject = (rootNode = (ProjectTreeNode)treeNode).getProject()) != project) continue;
                return rootNode;
            }
        }
        return null;
    }

    public static void refreshRootTreeFilter() {
        AbstractStudioWorkbench.getInstance().getProjectTree().reload();
    }

    public static List<ProjectObject> calculatePath(ProjectObject projectObject) {
        if (projectObject == null) {
            return CollectionFactory.createList();
        }
        if (projectObject.getParentObject() == null) {
            return CollectionFactory.createListWith(projectObject);
        }
        List<ProjectObject> path = ProjectNavigatorTree.calculatePath(projectObject.getParentObject());
        path.add(projectObject);
        return path;
    }

    public ProjectListener<ProjectObject> getProjectListenerDelegate() {
        return this.projectListenerDelegate;
    }

    public void setProjectListenerDelegate(ProjectListener<ProjectObject> projectListenerDelegate) {
        this.projectListenerDelegate = projectListenerDelegate;
    }

    public void setAsApplicationTree() {
        mainTree = this;
    }

    public boolean isAutoScrollFromSource() {
        return this.autoScrollFromSource;
    }

    public void setAutoScrollToSource(boolean autoScrollToSource) {
        if (this.autoScrollListener == null) {
            this.autoScrollListener = new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    TreePath p = e.getNewLeadSelectionPath();
                    if (p != null) {
                        ((ProjectObjectTreeNode)((Object)p.getLastPathComponent())).doSafeOpen();
                    }
                }
            };
        }
        if (autoScrollToSource) {
            this.addTreeSelectionListener(this.autoScrollListener);
        } else {
            this.removeTreeSelectionListener(this.autoScrollListener);
        }
    }

    public Project getProject() {
        return this.root.getProject();
    }

    public void setShowMenues(boolean showmenues) {
        this.showMenues_d = showmenues;
    }

    public boolean getShowMenues() {
        return this.showMenues_d;
    }

    public void selectRoot() {
        this.setSelectionPath(TreePath.create((Object[])this.getRoot().getPath()));
    }

    public boolean showProjectInherited() {
        return this.showProjectInherited;
    }

    public void setAutoScrollFromSource(boolean autoScrollFromSource) {
        this.autoScrollFromSource = autoScrollFromSource;
    }

    public void registerLanguageListener() {
        if (this.languageListener == null) {
            this.languageListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("language".equals(evt.getPropertyName())) {
                        Tree.allNodesChanged((Tree)ProjectNavigatorTree.this);
                    }
                }
            };
            EditorPreferences.getInstance().addListener(this.languageListener);
        }
    }

    public void clean() {
        this.getProjectRepository().removeRepositoryListener(this.repositoryListener);
    }

    public ProjectTreeNode findProjectTreeNode(Project p) {
        for (TreeNode treeNode : this.getRoot().getChildren()) {
            ProjectTreeNode projectTreeNode = (ProjectTreeNode)treeNode;
            if (!projectTreeNode.getProject().equals(p)) continue;
            return projectTreeNode;
        }
        return null;
    }

    public void accept(TreeNodeVisitor visitor) {
        this.getRoot().accept(visitor);
    }

    public void selectProcessesRoot(Project p) {
        ProjectTreeNode treeNode = this.findProjectTreeNode(p);
        if (treeNode != null) {
            treeNode.expand();
        }
    }

    public TreeNode findNode(ProjectObject projectObject) {
        TreeNodeFinder treeNodeVisitor = new TreeNodeFinder(projectObject, this.filter, this.getRoot());
        this.accept(treeNodeVisitor);
        return treeNodeVisitor.getNodeFound();
    }

    public List<TreeNode> findAndSelect(String text, boolean multiple, Predicate<ProjectObject> expectedClass) {
        TextFinder textFinder = new TextFinder(text, expectedClass);
        this.accept(textFinder);
        List<TreeNode> result = textFinder.getResult();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        for (TreeNode treeNode : result) {
            TreeNode parent = treeNode.getParent();
            if (parent != null && !parent.isExpanded()) {
                parent.expand();
            }
            paths.add(TreePath.create((Object[])treeNode.getPath()));
        }
        if (paths.isEmpty()) {
            this.setSelectionRow(-1);
        } else if (multiple) {
            this.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
        } else {
            this.setSelectionPath((TreePath)paths.get(0));
        }
        return result;
    }

    public ProjectObjectTreeNode getRoot() {
        return (ProjectObjectTreeNode)super.getRoot();
    }

    public void changeRepository(ProjectRepository repository) {
        if (this.getProjectRepository() != null) {
            this.getProjectRepository().removeRepositoryListener(this.getRepositoryListener());
        }
        if (repository != null) {
            repository.addRepositoryListener(this.getRepositoryListener());
        }
        this.setProjectRepository(repository);
        this.reloadTree();
        this.loadBaseTree();
    }

    public ProjectRepository getProjectRepository() {
        return this.projectRepository;
    }

    protected static int getProjectTreeTypesFilter() {
        if (DesignerMode.isBusinessAnalyst()) {
            return 0x30000080;
        }
        if (DesignerPreferences.getPreferences().isShowHiddenComponents()) {
            return 1072701183;
        }
        return 1055923967;
    }

    protected void buildMultiplePopup(MouseEvent e) {
        int[] multipleActions = AbstractTreeNode.getMultipleActions();
        int[] selectionRows = this.getSelectionRows();
        PopupMenu menu = new PopupMenu();
        boolean containsSomething = false;
        ArrayList<AbstractTreeNode> list = new ArrayList<AbstractTreeNode>();
        block2: for (int multipleAction : multipleActions) {
            list.clear();
            for (int selectionRow : selectionRows) {
                TreePath selectionPath = this.getPathForRow(selectionRow);
                Object lastPathComponent = selectionPath.getLastPathComponent();
                if (!(lastPathComponent instanceof AbstractTreeNode)) {
                    return;
                }
                AbstractTreeNode node = (AbstractTreeNode)((Object)lastPathComponent);
                int actionsMask = node.getMultipleActionsMask();
                if ((actionsMask & multipleAction) == 0) continue block2;
                list.add(node);
            }
            switch (multipleAction) {
                default: 
            }
            MultipleAction command = new MultipleAction(this);
            boolean actionNotImplemented = false;
            for (AbstractTreeNode projectComponentTreeNode : list) {
                BaseAction action = projectComponentTreeNode.getActionForId(multipleAction);
                if (action != null) {
                    command.addAction(action);
                    continue;
                }
                actionNotImplemented = true;
            }
            if (actionNotImplemented) continue;
            menu.add((BaseAction)command);
            containsSomething = true;
        }
        if (containsSomething) {
            menu.show((UiComponent)this, e.getX(), e.getY());
        }
    }

    protected void buildPopup(MouseEvent e) {
        if (this.processUserEvents) {
            super.buildPopup(e);
        }
    }

    protected void deletePressed() {
        if (this.processUserEvents) {
            super.deletePressed();
        }
    }

    protected void doubleClick(MouseEvent e) {
        if (this.processUserEvents) {
            super.doubleClick(e);
        }
    }

    protected void enterPressed() {
        if (this.processUserEvents) {
            super.enterPressed();
        }
    }

    protected boolean multipleDelete() {
        boolean done = true;
        ArrayList<AbstractTreeNode> list = new ArrayList<AbstractTreeNode>();
        for (int selectionRow : this.getSelectionRows()) {
            TreePath selectionPath = this.getPathForRow(selectionRow);
            Object lastPathComponent = selectionPath.getLastPathComponent();
            if (!(lastPathComponent instanceof AbstractTreeNode)) {
                done = false;
                break;
            }
            AbstractTreeNode node = (AbstractTreeNode)((Object)lastPathComponent);
            int actionsMask = node.getMultipleActionsMask();
            if ((actionsMask & 1) == 0) {
                done = false;
                break;
            }
            list.add(node);
        }
        if (done) {
            MultipleAction command = new MultipleAction(this);
            boolean actionNotImplemented = false;
            for (AbstractTreeNode projectComponentTreeNode : list) {
                BaseAction action = projectComponentTreeNode.getActionForId(1);
                if (action != null) {
                    command.addAction(action);
                    continue;
                }
                actionNotImplemented = true;
                break;
            }
            if (!actionNotImplemented) {
                command.doIt();
            }
        } else {
            ActionBindingMap.Binding binding;
            ActionBindingMap bindingMap = ActionBindingMap.getInstance();
            Set<String> actionSet = this.getSelectionCommonActions();
            Set<Object> classSet = this.getSelectionClasses();
            Class commonClass = ClassUtils.findCommonSuperclass(classSet);
            if (!actionSet.isEmpty() && actionSet.contains("delete-action") && (binding = bindingMap.get("delete-action", commonClass)) != null) {
                binding.getAction().actionPerformed(new ActionEvent((Object)this, "delete-action"));
            }
        }
        return true;
    }

    protected void multipleEnter() {
    }

    protected void processSelectNode(TreeSelectionEvent e) {
        if (this.processUserEvents) {
            super.processSelectNode(e);
        }
    }

    protected void singleClick(MouseEvent e) {
        if (this.processUserEvents) {
            super.singleClick(e);
        }
    }

    protected ProjectListener<ProjectObject> getProjectListener() {
        if (this.projectListener == null) {
            this.projectListener = new BatchProjectListenerAdapter<ProjectObject>(ProjectObject.class){

                public Class<ProjectObject> getSupportedTypes() {
                    return ProjectObject.class;
                }

                public void processPostEvents(final ProjectEventSet events) {
                    if (!UiUtilities.isEventDispatchThread()) {
                        UiUtilities.invokeLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                this.processPostEvents(events);
                            }
                        });
                        return;
                    }
                    for (ProjectEvent event : events) {
                        TreeNode parentNode;
                        ProjectObjectContainer parentObject;
                        ProjectFilter filter;
                        ProjectObject projectObject = event.getProjectObject();
                        if (event.getType() == ProjectEvent.Type.CHANGE) {
                            TreeNode node = ProjectNavigatorTree.this.findNode(projectObject);
                            if ("swap_children".equals(event.getPropertyName()) && node != null) {
                                int minIndex = (Integer)event.getOldValue();
                                int maxIndex = (Integer)event.getNewValue();
                                try {
                                    TreeNode child1 = node.getChildAt(maxIndex);
                                    TreeNode child2 = node.getChildAt(minIndex);
                                    node.remove(maxIndex);
                                    node.remove(minIndex);
                                    node.add(child2);
                                    node.add(child1);
                                    ProjectNavigatorTree.this.fireNodeStructureChanged(node);
                                    ProjectNavigatorTree.this.repaint();
                                }
                                catch (IndexOutOfBoundsException e) {
                                    // empty catch block
                                }
                            }
                            if (node == null || node.getParent() == null) continue;
                            node.nodeChanged();
                            continue;
                        }
                        if (event.getType() == ProjectEvent.Type.POST_ADD) {
                            filter = this.getProjectFilter();
                            parentObject = filter.getParent(projectObject);
                            boolean mustAdd = parentObject != null && filter.getChildren(parentObject).contains(projectObject);
                            if (!mustAdd) continue;
                            TreeNode treeNode = ProjectNavigatorTree.this.addNode(projectObject);
                            if (treeNode != null) {
                                ProjectNavigatorTree.this.fireNodeStructureChanged(treeNode);
                            }
                            ProjectNavigatorTree.this.repaint();
                            continue;
                        }
                        if (event.getType() != ProjectEvent.Type.POST_REMOVE || (parentObject = (filter = this.getProjectFilter()).getParent(projectObject)) == null || (parentNode = ProjectNavigatorTree.this.findNode((ProjectObject)parentObject)) == null) continue;
                        TreeNode childNode = ProjectNavigatorTree.this.findNode(projectObject);
                        if (parentNode.getChildren().contains(childNode)) {
                            ProjectNavigatorTree.this.removeNode(projectObject);
                        }
                        ProjectNavigatorTree.this.fireNodeStructureChanged(parentNode);
                        ProjectNavigatorTree.this.repaint();
                    }
                    if (ProjectNavigatorTree.this.projectListenerDelegate != null) {
                        ProjectNavigatorTree.this.projectListenerDelegate.processPostEvents(events);
                    }
                }

                private ProjectFilter getProjectFilter() {
                    return ProjectNavigatorTree.this.getRoot().getFilter();
                }
            };
        }
        return this.projectListener;
    }

    TreeNode addNode(ProjectObject projectObject) {
        ProjectFilter filter = this.getRoot().getFilter();
        ProjectObjectContainer parentObject = filter.getParent(projectObject);
        TreeNode parentNode = this.findNode((ProjectObject)parentObject);
        if (parentNode != null && parentNode.isLoaded() && parentNode.findChildByUserObject((Object)projectObject) == null) {
            return parentNode.addDynamic((Object)projectObject, (Comparator)ProjectObjectTreeNode.getComparator());
        }
        return null;
    }

    void removeNode(ProjectObject projectObject) {
        TreeNode child = this.findNode(projectObject);
        if (child != null) {
            child.removeFromParent();
        }
    }

    void changeNode(ProjectObject projectObject) {
        TreeNode node = this.findNode(projectObject);
        node.nodeChanged();
    }

    void replaceProjectObject(ProjectObject oldProjectObject, ProjectObject newProjectObject) {
        TreeNode node = this.findNode(oldProjectObject);
        node.setUserObject((Object)newProjectObject);
        node.nodeChanged();
    }

    private Set<Object> getSelectionClasses() {
        HashSet<Object> classSet = new HashSet<Object>();
        for (int row : this.getSelectionRows()) {
            classSet.add(this.getPathForRow(row).getLastPathComponent());
        }
        return classSet;
    }

    private Set<String> getSelectionCommonActions() {
        HashSet<String> keySet = new HashSet<String>();
        for (int row : this.getSelectionRows()) {
            TreePath selectionPath = this.getPathForRow(row);
            TreeNode node = (TreeNode)selectionPath.getLastPathComponent();
            Map commonActionsMap = node.getCommonActionsMap();
            if (!commonActionsMap.isEmpty()) {
                Set commonKeySet = commonActionsMap.keySet();
                if (keySet.isEmpty()) {
                    keySet.addAll(commonKeySet);
                    continue;
                }
                keySet.retainAll(commonKeySet);
                continue;
            }
            keySet.clear();
            break;
        }
        return keySet;
    }

    private RepositoryListener getRepositoryListener() {
        if (this.repositoryListener == null) {
            this.repositoryListener = new RepositoryAdapter(){

                public void projectCreated(Project project) {
                    ProjectNavigatorTree.this.addNode((ProjectObject)project);
                }

                public void projectOpened(Project project) {
                    this.reload();
                    project.addListener(ProjectNavigatorTree.this.getProjectListener());
                }

                public void projectDeleted(Project project) {
                    ProjectNavigatorTree.this.removeNode((ProjectObject)project);
                    project.removeListener(ProjectNavigatorTree.this.getProjectListener());
                }

                public void preProjectClose(Project project) {
                    TreeNode projectNode = ProjectNavigatorTree.this.findNode((ProjectObject)project);
                    if (projectNode != null) {
                        projectNode.unload();
                    }
                }

                public void projectClosed(Project project) {
                    this.reload();
                }

                private void reload() {
                    TreeNode projectNode = ProjectNavigatorTree.this.findNode(ProjectNavigatorTree.this.root);
                    if (projectNode != null) {
                        projectNode.reload();
                    }
                }
            };
        }
        return this.repositoryListener;
    }

    private void reloadTree() {
        this.getRoot().unload();
        this.getRoot().loadTree();
    }

    private void loadBaseTree() {
        ProjectRepository repository = this.getProjectRepository();
        if (repository != null) {
            for (Project p : repository.getOpenedProjects()) {
                p.addListener(this.getProjectListener());
                ProjectTreeNode projectTreeNode = new ProjectTreeNode(p);
                this.getRoot().add(projectTreeNode);
            }
        }
    }

    private void initDnD() {
        new DragSourceHandler((UiComponent)this, DndAction.COPY_OR_MOVE){
            private DragItem dragItem;
            {
                this.dragItem = null;
            }

            public Object getObject(Transfer transfer) {
                return this.dragItem.getObjectAs(transfer);
            }

            public Transfer[] getTransfers() {
                TreeNode node = ProjectNavigatorTree.this.getSelectedTreeNode();
                this.dragItem = node instanceof DragItem ? (DragItem)node : null;
                return this.dragItem != null ? this.dragItem.getTransfers() : Transfer.NONE;
            }
        };
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance(), LocalObjectTransfer.getInstance(Object.class), LocalObjectTransfer.getInstance(Process.class), LocalObjectTransfer.getInstance(FolderContainer.class), LocalObjectTransfer.getInstance(Role.class)};
        new DropTargetHandler((UiComponent)this, DndAction.COPY_OR_MOVE, transfers){
            private DropItem dropItem;
            {
                this.dropItem = null;
            }

            public void drop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                if (this.dropItem != null) {
                    this.dropItem.drop(data, transfer, point, dndAction);
                }
            }

            public boolean canDrop(Object data, Transfer transfer, Point point, DndAction dndAction) {
                TreePath path = ProjectNavigatorTree.this.getPathForLocation(point.getX(), point.getY());
                Object node = path != null ? path.getLastPathComponent() : null;
                this.dropItem = node instanceof DropItem ? (DropItem)node : null;
                return this.dropItem != null && this.dropItem.canDrop(data, transfer, point, dndAction);
            }
        };
    }

    private void setProjectRepository(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    private class TextFinder
    implements TreeNodeVisitor {
        private Predicate<ProjectObject> expectedClass;
        private List<TreeNode> result = new ArrayList<TreeNode>();
        private String text;

        public TextFinder(String text, Predicate<ProjectObject> expectedClass) {
            this.expectedClass = expectedClass;
            this.text = text.toLowerCase();
        }

        public boolean visit(TreeNode treeNode) {
            if (!treeNode.isRoot() && treeNode.getText().toLowerCase().contains(this.text) && this.isExpectedSelection(treeNode.getUserObject())) {
                this.result.add(treeNode);
            }
            return true;
        }

        public List<TreeNode> getResult() {
            return this.result;
        }

        private boolean isExpectedSelection(Object userObject) {
            return userObject instanceof ProjectObject && this.expectedClass.check((ProjectObject)userObject);
        }
    }

    private static class TreeNodeFinder
    implements TreeNodeVisitor {
        private TreeNode nodeFound;
        private ProjectObject parentObject;
        private Iterator<ProjectObject> pathIterator;

        public TreeNodeFinder(ProjectObject projectObject, ProjectFilter filter, TreeNode rootNode) {
            List<ProjectObject> path = ProjectObjectTreeModel.calculatePath(projectObject, filter, rootNode);
            this.pathIterator = path.iterator();
            this.parentObject = this.pathIterator.hasNext() ? this.pathIterator.next() : null;
        }

        public boolean visit(TreeNode treeNode) {
            if (mainTree.getRoot() == treeNode) {
                if (this.parentObject == null) {
                    this.nodeFound = treeNode;
                    return false;
                }
                return true;
            }
            if (treeNode.getUserObject() == this.parentObject) {
                if (this.pathIterator.hasNext()) {
                    this.parentObject = this.pathIterator.next();
                    return true;
                }
                this.nodeFound = treeNode;
            }
            return false;
        }

        public TreeNode getNodeFound() {
            return this.nodeFound;
        }
    }
}

