/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.Color;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.project.ui.wizards.ImportWizardUserObject;
import oracle.bpm.ui.Button;
import oracle.bpm.ui.LabelMultiline;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiManager;
import oracle.bpm.ui.border.BorderFactory;
import oracle.bpm.ui.msg.UIMsg;
import oracle.bpm.ui.wizards.model.Wizard;
import oracle.bpm.ui.wizards.model.WizardStep;
import oracle.bpm.ui.wizards.ui.DynamicExecutorPanel;

public class ProjectCreationPanel
extends DynamicExecutorPanel {
    Button browseButton_d;
    private LabelMultiline area;
    private static final String CRLF = "\r\n";

    public ProjectCreationPanel(UiContainer parent, WizardStep wizardStep) {
        super(parent, wizardStep);
    }

    public void onFocus() {
        this.updateFromRoot();
    }

    public void setTaskText(String text) {
    }

    protected UiComponent createCenterPage(UiContainer parent) {
        this.setPageTitle(DesignerMsg.NEW_PROJECT_SUMMARY);
        this.setPageDesc(DesignerMsg.SHOWS_ALL_INFO_TO_CREATE_PROJECT);
        this.area = ProjectCreationPanel.createTextArea((UiContainer)parent, (String)this.getSummaryText());
        this.area.setBackground(UiManager.color((String)"TextArea.background"));
        this.area.setBorder(BorderFactory.createLineBorder((Color)UiManager.color((String)"controlDkShadow")));
        return this.area;
    }

    void updateFromRoot() {
        String text = this.getSummaryText();
        this.area.setMsg(UIMsg.TO_MSG((String)text));
    }

    private String getSummaryText() {
        Wizard wizard = this.getWizardStep().getWizard();
        StringBuffer buffer = new StringBuffer();
        buffer.append(ProjectMsg.PROJECT_NAME);
        buffer.append(":");
        buffer.append(CRLF);
        buffer.append(((ImportWizardUserObject)wizard.getUserObject()).getProjectName());
        buffer.append(CRLF);
        buffer.append(CRLF);
        buffer.append(ProjectMsg.PROJECT_ROOT_DIRECTORY);
        buffer.append(":");
        buffer.append(CRLF);
        buffer.append(((ImportWizardUserObject)wizard.getUserObject()).getProjectRootDirectory());
        buffer.append(CRLF);
        buffer.append(CRLF);
        return buffer.toString();
    }
}

