/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.adapter.Adaptable;
import oracle.bpm.designer.ProjectTreeNode;
import oracle.bpm.designer.action.ExportProjectAction;
import oracle.bpm.designer.action.NewModelAction;
import oracle.bpm.designer.action.NewModelContainerAction;
import oracle.bpm.designer.action.ProjectPreferencesAction;
import oracle.bpm.designer.action.ProjectToTemplateAction;
import oracle.bpm.designer.action.TemplateToProjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.extensionpoint.metadata.ActionGroupMetadata;
import oracle.bpm.project.model.Project;
import oracle.bpm.ui.ActionOrder;
import oracle.bpm.ui.action.ActionGroup;
import oracle.bpm.ui.action.ActionGroupFactory;
import oracle.bpm.ui.action.BaseAction;

@ActionGroupMetadata(target=ProjectTreeNode.class)
public class ProjectActions
implements ActionGroupFactory {
    public ActionGroup create(Adaptable context) {
        ProjectTreeNode node = context.as(ProjectTreeNode.class);
        ActionGroup result = new ActionGroup(node.getMsg());
        Project project = node.getProject();
        if (node.isProjectOpen()) {
            ActionGroup newGroup = new ActionGroup(DesignerMsg.NEW);
            newGroup.setOrder(ActionOrder.FIRST);
            result.addSeparator();
            result.add((BaseAction)newGroup);
            ProjectActions.addNewActions(newGroup);
            result.add((BaseAction)new ExportProjectAction());
            result.addSeparator();
            if (!project.isTemplate()) {
                result.add((BaseAction)new ProjectToTemplateAction());
            } else {
                result.add((BaseAction)new TemplateToProjectAction());
            }
        }
        result.add((BaseAction)new ProjectPreferencesAction());
        return result;
    }

    static void addNewActions(ActionGroup group) {
        group.add((BaseAction)new NewModelAction());
        group.add((BaseAction)new NewModelContainerAction());
    }
}

