/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import oracle.bpm.draw.AntialiasingMode;
import oracle.bpm.draw.BpmnDrawableFactory;
import oracle.bpm.draw.DrawContext;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableChildPopulator;
import oracle.bpm.draw.DrawableFactory;
import oracle.bpm.draw.DrawableProcess;
import oracle.bpm.draw.DrawableSingleProcessRoot;
import oracle.bpm.draw.Graphics;
import oracle.bpm.geom.Dimension;
import oracle.bpm.geom.Rectangle;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.ui.PaintCanvas;
import oracle.bpm.ui.UiContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProcessPreviewer
extends PaintCanvas {
    private DrawContext context = new DrawContext();
    private DrawableSingleProcessRoot root = DrawableSingleProcessRoot.create((PaintCanvas)this);

    public ProcessPreviewer(@NotNull UiContainer parent) {
        super(parent);
    }

    public Dimension getPreferredSize() {
        return this.getVisibleRect().getSize();
    }

    public void paintCanvas(@NotNull Graphics graphics) {
        if (this.root.hasSingleProcess()) {
            graphics.setAntialiasing(AntialiasingMode.ON);
            this.initDrawContext(graphics, this.getVisibleRect());
            this.root.draw(this.getDrawContext());
        }
    }

    @NotNull
    public DrawableProcess getDrawableProcess() {
        return this.root.getSingleProcess();
    }

    public DrawContext getDrawContext() {
        return this.context;
    }

    public void setProcessToRender(@Nullable Process process) {
        this.clearRoot();
        if (process != null) {
            this.addProcessToRoot(process);
        }
    }

    protected void initDrawContext(Graphics graphics, Rectangle rect) {
        this.context.setGraphics(graphics);
        this.context.setContainer((UiContainer)this);
        this.context.setRectangle(rect);
        this.context.setScale(1.0f);
        this.context.setRenderFlowOnly(false);
        Rectangle bounds = this.root.getBounds(this.context);
        float scalex = (float)rect.getWidth() / (float)bounds.getWidth();
        float scaley = (float)rect.getHeight() / (float)bounds.getHeight();
        this.context.setScale(Math.min(scalex, scaley));
    }

    private void clearRoot() {
        for (Drawable child : this.root.getDrawables()) {
            child.remove();
        }
    }

    private void addProcessToRoot(@NotNull Process process) {
        BpmnDrawableFactory factory = BpmnDrawableFactory.getInstance();
        DrawableChildPopulator.populateChild((DrawableFactory)factory, (Drawable)this.root, (Object)process, (DrawContext)this.context);
    }
}

