/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.net.URISyntaxException;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.DesignerException;
import oracle.bpm.designer.DesignerMode;
import oracle.bpm.designer.DesignerResources;
import oracle.bpm.designer.GenerateEventFeatureEditor;
import oracle.bpm.designer.NamespaceFeatureEditor;
import oracle.bpm.designer.ProcessNameIsNullException;
import oracle.bpm.designer.ProcessSealTypePanel;
import oracle.bpm.designer.argumentsdefinition.ArgumentsDefinitionPanel;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.draw.msg.ProjectDrawMsg;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.FuegoProject;
import oracle.bpm.project.ProcessArgumentContainer;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.catalog.DataDeclaration;
import oracle.bpm.project.model.catalog.DataDeclarationContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.features.NamespaceFeature;
import oracle.bpm.project.model.features.ProcessSealTypeFeature;
import oracle.bpm.project.model.processes.EndEvent;
import oracle.bpm.project.model.processes.EventTriggerType;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.StartEvent;
import oracle.bpm.project.model.processes.activities.ProcessGenerateEventsFeature;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.project.msg.ProjectMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.MessageDialog;
import oracle.bpm.ui.MirrorTextArea;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.TabbedPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiUtilities;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.layout.form.CellConstraints;
import oracle.bpm.ui.layout.form.FormLayout;
import oracle.bpm.ui.layout.form.PanelBuilder;
import oracle.bpm.ui.text.TextArea;
import oracle.bpm.ui.text.TextComponent;
import oracle.bpm.ui.text.TextField;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;

public class ProcessInfoPanel
extends Panel {
    private ArgumentsDefinitionPanel argumentsDefinitionPanel;
    private TextField author;
    private boolean dataModified = false;
    private TextArea description;
    private GenerateEventFeatureEditor generateEventFeatureEditor;
    private DataDeclarationContainer inputDataDeclarationContainer;
    private boolean isNew;
    private TextField label;
    private Process model;
    private Label name;
    private NamespaceFeatureEditor namespaceFeatureEditor;
    private DataDeclarationContainer outputDataDeclarationContainer;
    private ProcessSealTypePanel sealEditor;
    private TabbedPane tabbedPane;

    public ProcessInfoPanel(UiContainer parent, Process content) {
        this(parent, content, false);
    }

    public ProcessInfoPanel(UiContainer parent, Process content, final boolean isNew) {
        super(parent);
        this.model = content;
        this.dataModified = false;
        this.isNew = isNew;
        this.setLayout((Layout)new BorderLayout());
        this.tabbedPane = new TabbedPane((UiContainer)this);
        Panel generalPanel = new Panel((UiContainer)this.tabbedPane);
        this.tabbedPane.addTab(DesignerMsg.GENERAL, (UiComponent)generalPanel);
        Panel advancedPanel = new Panel((UiContainer)this.tabbedPane);
        this.tabbedPane.addTab(CoreMsg.ADVANCED, (UiComponent)advancedPanel);
        if (this.mustShowArgs()) {
            this.tabbedPane.addTab(DesignerMsg.ARGUMENTS_DEFINITION, (UiComponent)this.buildArgsPanel((UiContainer)this.tabbedPane));
        }
        this.buildMainPanel(generalPanel);
        this.buildAdvancedPanel(advancedPanel);
        this.add((UiComponent)this.tabbedPane, "Center");
        this.objectToPanel();
        UiUtilities.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (isNew) {
                    ProcessInfoPanel.this.label.selectAll();
                }
                ProcessInfoPanel.this.label.requestFocus();
            }
        });
    }

    public String getHelpId() {
        return this.tabbedPane.getDefaultHelpId();
    }

    public Process getModel() {
        return this.model;
    }

    public String getProcessDescription() {
        return this.description.getText();
    }

    public String getProcessName() {
        return this.name.getText();
    }

    public boolean ok() {
        try {
            this.checkValues();
        }
        catch (DesignerException exc) {
            MessageDialog.showError((Throwable)((Object)exc));
            this.label.grabFocus();
            this.label.setSelectionStart(0);
            this.label.setSelectionEnd(this.label.getText().length());
            return false;
        }
        this.panelToObject();
        return true;
    }

    private boolean mustShowArgs() {
        Sequence startEventSequence = this.model.getEvents(StartEvent.class, EventTriggerType.MESSAGE);
        return this.isNew && !startEventSequence.isEmpty() || this.model.isCallableSubprocess();
    }

    private Panel buildArgsPanel(UiContainer parent) {
        Panel result = new Panel(parent);
        result.setLayout((Layout)new MigLayout("ins 5, gap 5, fill"));
        if (this.model.isCallableSubprocess()) {
            this.outputDataDeclarationContainer = this.model.getInputArgumentsContainer();
            this.inputDataDeclarationContainer = this.model.getOutputArgumentsContainer();
        } else {
            Sequence startEventSequence = this.model.getEvents(StartEvent.class);
            StartEvent startEvent = (StartEvent)startEventSequence.iterator().next();
            Sequence endEventSequence = this.model.getEvents(EndEvent.class);
            EndEvent endEvent = (EndEvent)endEventSequence.iterator().next();
            this.outputDataDeclarationContainer = startEvent.getOutputArgumentsContainer();
            this.inputDataDeclarationContainer = endEvent.getInputArgumentsContainer();
        }
        ProcessArgumentContainer inputsContainer = new ProcessArgumentContainer(this.outputDataDeclarationContainer);
        ProcessArgumentContainer outputsContainer = new ProcessArgumentContainer(this.inputDataDeclarationContainer);
        this.argumentsDefinitionPanel = new ArgumentsDefinitionPanel((UiContainer)result, (DataDeclarationContainer)inputsContainer, (DataDeclarationContainer)outputsContainer);
        result.add((UiComponent)this.argumentsDefinitionPanel, (Object)"grow");
        return result;
    }

    private void addDocumentListenerTo(TextComponent component) {
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                ProcessInfoPanel.this.dataModified = true;
            }

            public void removeUpdate(DocumentEvent e) {
                ProcessInfoPanel.this.dataModified = true;
            }

            public void changedUpdate(DocumentEvent e) {
                ProcessInfoPanel.this.dataModified = true;
            }
        };
        component.addDocumentListener(documentListener);
    }

    private void addListeners() {
        if (this.isNew) {
            this.label.addDocumentListener(new DocumentListener(){

                public void insertUpdate(DocumentEvent e) {
                    ProcessInfoPanel.this.name.setText(ProcessInfoPanel.this.cutName());
                    ProcessInfoPanel.this.namespaceFeatureEditor.setNamespace("http://xmlns.oracle.com/bpmn/bpmnProcess/" + ProcessInfoPanel.this.name.getText());
                }

                public void removeUpdate(DocumentEvent e) {
                    ProcessInfoPanel.this.name.setText(ProcessInfoPanel.this.cutName());
                    ProcessInfoPanel.this.namespaceFeatureEditor.setNamespace("http://xmlns.oracle.com/bpmn/bpmnProcess/" + ProcessInfoPanel.this.name.getText());
                }

                public void changedUpdate(DocumentEvent e) {
                    ProcessInfoPanel.this.name.setText(ProcessInfoPanel.this.cutName());
                    ProcessInfoPanel.this.namespaceFeatureEditor.setNamespace("http://xmlns.oracle.com/bpmn/bpmnProcess/" + ProcessInfoPanel.this.name.getText());
                }
            });
        }
    }

    private void addAdvancedPanelRow(PanelBuilder builder, UiComponent component, CellConstraints constraints) {
        String row = "p";
        FormLayout layout = builder.getLayout();
        layout.appendRow(row);
        String gap = "5dlu";
        layout.appendRow(gap);
        int y = layout.getRowCount() - 1;
        builder.add(component, constraints.xywh(2, y, 4, 1));
    }

    private void buildAdvancedPanel(Panel parent) {
        String cols = "5dlu, pref, 5dlu, pref:grow, pref, 5dlu";
        FormLayout layout = new FormLayout(cols);
        PanelBuilder builder = layout.createBuilder(parent);
        CellConstraints constraints = layout.createCellConstraints();
        if (DesignerMode.isValid(2)) {
            this.generateEventFeatureEditor = new GenerateEventFeatureEditor((UiContainer)parent, (ProcessGenerateEventsFeature)this.getModel().getFeature(ProcessGenerateEventsFeature.class));
            this.addAdvancedPanelRow(builder, (UiComponent)this.generateEventFeatureEditor, constraints);
        }
        if (this.isNew) {
            this.namespaceFeatureEditor = new NamespaceFeatureEditor((UiContainer)parent, (NamespaceFeature)this.getModel().getFeature(NamespaceFeature.class));
            this.addAdvancedPanelRow(builder, (UiComponent)this.namespaceFeatureEditor, constraints);
            layout.appendRow("10dlu");
        }
        if (this.model.getProject().isTemplate()) {
            this.sealEditor = new ProcessSealTypePanel((UiContainer)parent, (ProcessSealTypeFeature)this.model.getFeature(ProcessSealTypeFeature.class));
            this.addAdvancedPanelRow(builder, (UiComponent)this.sealEditor, constraints);
            layout.appendRow("10dlu");
        }
    }

    private void buildMainPanel(Panel parent) {
        this.name = Label.createWithNoColon((UiContainer)parent, (Msg)Msg.QUOTE(""));
        this.name.setFont(this.name.getFont().italic());
        this.label = new TextField((UiContainer)parent, 30);
        this.addDocumentListenerTo((TextComponent)this.label);
        this.description = new MirrorTextArea((UiContainer)parent, (TextComponent)this.label);
        this.description.setLineWrap(true);
        this.description.setColumns(30);
        this.description.setRows(5);
        this.description.setWrapStyleWord(true);
        this.addDocumentListenerTo((TextComponent)this.description);
        this.author = new TextField((UiContainer)parent, "");
        this.addDocumentListenerTo((TextComponent)this.author);
        String cols = "5dlu, pref, 5dlu, pref:grow, pref, 5dlu";
        String innerGap = "3dlu";
        String outterGap = "6dlu";
        String prefered = ",p,";
        String rows = "p," + innerGap + prefered + innerGap + prefered + outterGap + prefered + innerGap + prefered + outterGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered + innerGap + prefered;
        FormLayout layout = new FormLayout(cols, rows);
        PanelBuilder builder = layout.createBuilder(parent);
        CellConstraints constraints = layout.createCellConstraints();
        builder.addSeparator(ProjectDrawMsg.NAME.getString(), constraints.xywh(2, 1, 4, 1));
        builder.add((UiComponent)this.label, constraints.xywh(2, 3, 3, 1));
        builder.add((UiComponent)DesignerResources.buildLocalizationButton(this.getModel().getProject(), (UiContainer)parent, this.model.getLabelMap(), (TextComponent)this.label, DesignerMsg.LOCALIZE_LABEL.getString()), constraints.xy(5, 3));
        builder.add((UiComponent)Label.create((UiContainer)parent, (Msg)CoreMsg.ID), constraints.xy(2, 5));
        builder.add((UiComponent)this.name, constraints.xywh(3, 5, 2, 1));
        builder.addSeparator(DesignerMsg.DESCRIPTION.getString(), constraints.xywh(2, 7, 4, 1));
        builder.add((UiComponent)this.description, constraints.xywh(2, 9, 3, 1));
        builder.add((UiComponent)DesignerResources.buildLocalizationButton(this.getModel().getProject(), (UiContainer)parent, this.model.getDescriptionMap(), (TextComponent)this.description, DesignerMsg.LOCALIZE_LABEL.getString(), true), constraints.xy(5, 9));
        builder.addSeparator(DesignerMsg.OTHERS.getString(), constraints.xywh(2, 11, 4, 1));
        builder.add((UiComponent)Label.create((UiContainer)parent, (Msg)ProjectMsg.AUTHOR), constraints.xy(2, 15));
        builder.add((UiComponent)this.author, constraints.xywh(4, 15, 2, 1));
    }

    private void checkValues() throws DesignerException {
        Process process;
        if (this.name.getText() == null || this.name.getText().length() == 0 || Character.isDigit(this.name.getText().charAt(0))) {
            throw new ProcessNameIsNullException(this.model, SchemaType.PROCESS.getString());
        }
        if (this.label.getText() == null || this.label.getText().length() == 0 || Character.isDigit(this.label.getText().charAt(0))) {
            throw new ProcessNameIsNullException(this.model, SchemaType.PROCESS.getString());
        }
        if (this.namespaceFeatureEditor != null) {
            try {
                this.namespaceFeatureEditor.checkValues();
            }
            catch (URISyntaxException e) {
                throw new DesignerException(DesignerMsg.INVALID_NAMESPACE);
            }
        }
        if ((process = this.model.getProject().findProcess(this.name.getText())) != null && process != this.model) {
            throw new DesignerException(DesignerMsg.PROCESS_ID_EXISTS);
        }
    }

    private String cutName() {
        FuegoProject project = (FuegoProject)this.model.getProject();
        String cut = Identifier.classname(project.getNextValidNameForProcess(this.label.getText()), false);
        if (cut != null && cut.length() > 128) {
            cut = cut.substring(0, 128);
        }
        if (cut == null || cut.isEmpty()) {
            SchemaType schemaType = SchemaType.PROCESS;
            cut = project.getNextValidNameForProcess(schemaType.toString());
            cut = Identifier.classname(cut.toLowerCase());
        }
        return cut;
    }

    private void objectToPanel() {
        if (this.generateEventFeatureEditor != null) {
            this.generateEventFeatureEditor.fromFeature();
        }
        if (this.namespaceFeatureEditor != null) {
            this.namespaceFeatureEditor.fromFeature();
        }
        if (this.description != null) {
            this.description.setText(this.model.getDefaultDescription());
        }
        if (this.isNew && (this.model.getAuthor() == null || "".equals(this.model.getAuthor()))) {
            this.author.setText(System.getProperty("user.name"));
        } else {
            this.author.setText(this.model.getAuthor());
        }
        this.addListeners();
        String defaultLabel = this.model.getDefaultLabel();
        if (defaultLabel != null && !"".equals(defaultLabel)) {
            this.label.setText(defaultLabel);
            this.name.setText(this.model.getId());
        } else {
            this.label.setText(ModelUtils.nextNameForModel((Project)this.model.getProject(), (String)SchemaType.PROCESS.getString()));
        }
        if (this.model.getProject().isTemplate()) {
            this.sealEditor.fromFeature();
        }
    }

    private void addAllArguments() {
        this.copyArguments(this.argumentsDefinitionPanel.getInputArgumentsContainer(), this.outputDataDeclarationContainer);
        this.copyArguments(this.argumentsDefinitionPanel.getOutputsArgumentsContainer(), this.inputDataDeclarationContainer);
    }

    private void copyArguments(@NotNull DataDeclarationContainer source, @NotNull DataDeclarationContainer target) {
        try {
            target.clearDeclarations();
            for (DataDeclaration argument : source.getLocalDeclarations()) {
                DataDeclaration inputArg = target.createDeclaration(argument.getName(), argument.getType());
                target.addDeclaration(inputArg);
            }
        }
        catch (ProjectException e) {
            throw new RuntimeException(e);
        }
    }

    private void panelToObject() {
        this.model.setId(this.name.getText());
        this.model.setAuthor(this.author.getText());
        this.model.setDefaultLabel(this.label.getText());
        this.model.setDefaultDescription(this.description.getText());
        if (this.generateEventFeatureEditor != null) {
            this.generateEventFeatureEditor.toFeature();
        }
        if (this.model.getProject().isTemplate()) {
            this.sealEditor.toFeature();
        }
        if (this.namespaceFeatureEditor != null) {
            this.namespaceFeatureEditor.toFeature();
        }
        if (this.argumentsDefinitionPanel != null) {
            this.addAllArguments();
        }
    }
}

