/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import oracle.bpm.designer.ProcessDomain;
import oracle.bpm.designer.controller.Controller;
import oracle.bpm.designer.controller.FlowElementController;
import oracle.bpm.draw.Drawable;
import oracle.bpm.draw.DrawableFlowElement;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.events.BatchProjectListenerAdapter;
import oracle.bpm.project.model.events.ProjectEvent;
import oracle.bpm.project.model.events.ProjectEventSet;
import oracle.bpm.project.model.processes.Counter;
import oracle.bpm.project.model.processes.FlowElement;
import org.jetbrains.annotations.NotNull;

class ProcessDomainEventDispatcher
extends BatchProjectListenerAdapter<FlowElement> {
    private Map<ProjectObject, Controller> controllers = new HashMap<ProjectObject, Controller>();
    private final ProcessDomain domain;

    public ProcessDomainEventDispatcher(ProcessDomain domain) {
        super(FlowElement.class);
        this.domain = domain;
    }

    public void processPostEvents(ProjectEventSet events) {
        LinkedHashSet<Controller> toBeRefreshed = new LinkedHashSet<Controller>();
        for (ProjectEvent event : events) {
            Controller controller;
            ProjectObject object = event.getProjectObject();
            if (!(object instanceof FlowElement) || object instanceof Counter) continue;
            if (event.getType() == ProjectEvent.Type.POST_ADD) {
                this.addChild(this.controllers.get(object.getParentObject()), object);
            } else if (event.getType() == ProjectEvent.Type.POST_REMOVE) {
                this.removeChild(object);
            }
            if ((controller = this.controllers.get(object)) == null) continue;
            toBeRefreshed.add(controller);
        }
        for (Controller controller : toBeRefreshed) {
            controller.refresh();
        }
    }

    public void unregister(Controller<? extends FlowElement> controller) {
        this.controllers.remove(controller.getModelObject());
    }

    public void register(Controller<? extends FlowElement> controller) {
        this.controllers.put((ProjectObject)controller.getModelObject(), controller);
    }

    private void addChild(@NotNull Controller parent, @NotNull ProjectObject child) {
        DrawableFlowElement drawable = this.domain.getDrawableFactory().create(parent.getDrawableObject(), (Object)child);
        FlowElementController controller = this.domain.getControllerFactory().create(parent, (Drawable)drawable);
        controller.add();
    }

    private void removeChild(@NotNull ProjectObject child) {
        Controller controller = this.controllers.get(child);
        if (controller != null) {
            controller.remove();
        } else {
            Thread.dumpStack();
        }
    }
}

