/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.ProjectObjectBrowser;
import oracle.bpm.designer.conversation.ReferenceComboBox;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.BpmnType;
import oracle.bpm.project.model.processes.ConversationEnabled;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.NodeContainer;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.processes.ProcessCommunicationEnabled;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessCommunicationEditorPanel
extends ProjectObjectEditorPanel<ProcessCommunicationEnabled> {
    protected ReferenceComboBox<ConversationEnabled> nodeComboBox;
    protected ProjectObjectBrowser<Process> processBrowser;

    public ProcessCommunicationEditorPanel(@NotNull UiContainer parent, @NotNull ProcessCommunicationEnabled projectObject) {
        this(parent, projectObject, null);
    }

    public ProcessCommunicationEditorPanel(@NotNull UiContainer parent, @NotNull ProcessCommunicationEnabled projectObject, Process fixedProcess) {
        super(parent, projectObject);
        this.init(fixedProcess);
        this.processBrowser.setValue(fixedProcess);
    }

    @Override
    public void objectToEditor(ProcessCommunicationEnabled projectObject) {
        ProcessCommunicationEnabled processCommunicationEnabled = (ProcessCommunicationEnabled)this.getProjectObject();
        this.processBrowser.setValue(processCommunicationEnabled.getAssociatedProcess());
        this.nodeComboBox.setSelectedItem(processCommunicationEnabled.getAssociatedNode());
    }

    @Override
    public ProcessCommunicationEnabled editorToObject() throws ProjectException {
        ProcessCommunicationEnabled processCommunicationEnabled = (ProcessCommunicationEnabled)this.getProjectObject();
        processCommunicationEnabled.setAssociatedNode((ConversationEnabled)this.nodeComboBox.getSelectedItem());
        return processCommunicationEnabled;
    }

    @Override
    public void validatePanel() throws ProjectException {
        Object projectObject = this.getProjectObject();
        String label = ((FlowNode)projectObject).getDefaultLabel();
        if (this.processBrowser.getValue() != null && !this.processBrowser.isValidSelection()) {
            throw new ProjectException(projectObject, ProjectCompileMsg.PROCESS_INVALID((String)label));
        }
        if (this.nodeComboBox.getSelectedItem() != null && !this.nodeComboBox.isValidSelection()) {
            throw new ProjectException(projectObject, ProjectCompileMsg.NODE_INVALID((String)label));
        }
    }

    protected abstract Sequence<ConversationEnabled> getNodes();

    protected BpmnType getProjectObjectBpmnType() {
        return ((FlowNode)this.getProjectObject()).getBpmnType();
    }

    protected Process getSelectedProcess() {
        return this.processBrowser.getValue();
    }

    protected void reloadNodeComboBox() {
        this.nodeComboBox.removeAllItems();
        Process selectedProcess = this.getSelectedProcess();
        if (selectedProcess != null) {
            Sequence<ConversationEnabled> nodes = this.getNodes();
            for (ConversationEnabled node : nodes) {
                this.nodeComboBox.addItem(node);
            }
        }
    }

    private void init(Process fixedProcess) {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        DefaultProjectFilter filter = fixedProcess != null ? new FixedProcessFilter((ProjectObject)fixedProcess) : new ProcessFilter();
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.PROCESS));
        this.processBrowser = this.createProcessBrowser((UiContainer)this, (ProjectFilter)filter);
        this.add((UiComponent)this.processBrowser, "growx, gapx 5, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NODE));
        this.nodeComboBox = this.createNodeComboBox((UiContainer)this);
        this.add((UiComponent)this.nodeComboBox, "growx, gapx 5, gapy 5");
    }

    private Project getProject() {
        return ((ProcessCommunicationEnabled)this.getProjectObject()).getProject();
    }

    private ProjectObjectBrowser<Process> createProcessBrowser(@NotNull UiContainer container, @NotNull ProjectFilter filter) {
        ProjectObjectBrowser<Process> result = new ProjectObjectBrowser<Process>(container, filter, (ProjectObjectContainer)this.getProject());
        LabelProvider.Default<Process> labelProvider = new LabelProvider.Default<Process>(){

            public String getText(Process element) {
                return element.getName();
            }
        };
        result.setLabelProvider((LabelProvider<Process>)labelProvider);
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent event) {
                ProcessCommunicationEditorPanel.this.reloadNodeComboBox();
            }
        });
        return result;
    }

    private ReferenceComboBox<ConversationEnabled> createNodeComboBox(@NotNull UiContainer container) {
        ReferenceComboBox<ConversationEnabled> result = new ReferenceComboBox<ConversationEnabled>(container);
        LabelProvider.Default<ConversationEnabled> labelProvider = new LabelProvider.Default<ConversationEnabled>(){

            public String getText(ConversationEnabled element) {
                return ProcessCommunicationEditorPanel.this.createNodePath(element);
            }
        };
        result.setLabelProvider((LabelProvider)labelProvider);
        return result;
    }

    private String createNodePath(@NotNull ConversationEnabled node) {
        String result = node.getDefaultLabel();
        Process process = node.getProcess();
        for (NodeContainer container = node.getParentObject(); container != null && container != process && container instanceof NodeContainer; container = container.getParentObject()) {
            NodeContainer nodeContainer = container;
            result = nodeContainer.getDefaultLabel() + "." + result;
        }
        return result;
    }

    private class ProcessFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private ProcessFilter() {
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            Sequence<Object> result = CollectionUtils.emptySequence();
            if (object instanceof Project) {
                Project project = (Project)object;
                result = CollectionUtils.asSequence(project.getProcesses());
            }
            return result;
        }
    }

    private class FixedProcessFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private ProjectObject fixedProcess;

        private FixedProcessFilter(ProjectObject fixedProcess) {
            this.fixedProcess = fixedProcess;
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            ArrayList<Process> result = new ArrayList<Process>();
            try {
                if (object instanceof Project && this.fixedProcess != null) {
                    Project project = (Project)object;
                    Process child = project.findProcess(this.fixedProcess.getId());
                    result.add(child);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return CollectionUtils.asSequence(result);
        }
    }
}

