/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.List;
import javax.swing.Action;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoableEdit;
import oracle.bpm.cil.CilException;
import oracle.bpm.compiler.BreakPoint;
import oracle.bpm.compiler.CodeDebugger;
import oracle.bpm.compiler.LanguageSpec;
import oracle.bpm.designer.LanguageHelper;
import oracle.bpm.editor.CodeEditor;
import oracle.bpm.editor.CodeFixHandler;
import oracle.bpm.editor.EditorDocument;
import oracle.bpm.editor.EditorSupport;
import oracle.bpm.editor.UndoRedoListener;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ToolBar;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.action.BaseAction;
import oracle.bpm.ui.event.ChangeListener;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.selection.SelectionProvider;
import oracle.bpm.ui.text.TextArea;

class PlainExpressionEditor
extends Panel
implements CodeEditor {
    private MethodTypeDescription code;
    private boolean expression;
    private boolean expressionRequired;
    private LanguageSpec languageSpec;
    private ChangeListener listener;
    private TextArea textArea;
    private ToolBar toolBar;

    public PlainExpressionEditor(UiContainer parent, LanguageSpec languageSpec) {
        super(parent);
        this.languageSpec = languageSpec;
        this.setLayout((Layout)new BorderLayout());
        this.toolBar = new ToolBar((UiContainer)this);
        this.textArea = new TextArea((UiContainer)this);
        this.add((UiComponent)this.toolBar, "North");
        this.add((UiComponent)this.textArea, "Center");
        this.textArea.addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
            }

            public void insertUpdate(DocumentEvent e) {
            }

            public void removeUpdate(DocumentEvent e) {
            }
        });
    }

    public Action getActionByName(String name) {
        return null;
    }

    public void setAddToolBar(boolean addToolBar) {
        this.toolBar.setVisible(addToolBar);
    }

    public boolean isAddToolBar() {
        return this.toolBar.isVisible();
    }

    public void setCanBrowseDeclarations(boolean canBrowse) {
    }

    public void setCaretPosition(int offset) {
        this.textArea.setCaretPosition(offset);
    }

    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    public void setCloseAction(BaseAction action) {
    }

    public void setCode(MethodTypeDescription code) {
        this.code = code;
        String codeText = new String(code.getCodeText());
        try {
            if (!code.getCodeLanguage().equals(this.languageSpec.getId())) {
                codeText = LanguageHelper.changeLanguage(codeText, code.getCodeLanguage(), this.languageSpec.getName(), null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setText(codeText);
    }

    public MethodTypeDescription getCode() {
        return this.code;
    }

    public void setCompilerDirectives(int directives) {
    }

    public void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public EditorDocument getEditorDocument() {
        return null;
    }

    public void setExpression(boolean expression) {
        this.expression = expression;
    }

    public boolean isExpression() {
        return this.expression;
    }

    public void setExpressionRequired(boolean required) {
        this.expressionRequired = required;
    }

    public boolean isExpressionRequired() {
        return this.expressionRequired;
    }

    public void setFixHandler(CodeFixHandler fixHandler) {
    }

    public LanguageSpec getLanguage() {
        return this.languageSpec;
    }

    public List getLineBreakPoints() {
        return null;
    }

    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }

    public int getSelectionEnd() {
        return this.textArea.getSelectionEnd();
    }

    public int getSelectionStart() {
        return this.textArea.getSelectionStart();
    }

    public CodeDebugger.CILSource getSource() {
        return null;
    }

    public void setSupport(EditorSupport support) {
    }

    public EditorSupport getSupport() {
        return null;
    }

    public void setText(String text) {
        this.textArea.setText(text);
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String getText(int offset, int length) throws BadLocationException {
        return null;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public void setUndoRedoListener(UndoRedoListener listener) {
    }

    public void setValidate(boolean validate) {
    }

    public boolean isValidate() {
        return false;
    }

    public UiComponent getView() {
        return this;
    }

    public void addBreakPointMark(BreakPoint breakPoint) {
    }

    public void addChangeListener(ChangeListener listener) {
        this.listener = listener;
    }

    public void addDependableAction(Action action) {
    }

    public void addEdit(UndoableEdit undoableEdit) {
    }

    public void addError(CilException exception) {
    }

    public void addUndoableEditListener(UndoableEditListener listener) {
    }

    public void addWarning(CilException warning) {
    }

    public void checkChangeLanguage() {
    }

    public void clearUndoEvents() {
    }

    public boolean containsDependableAction(Action action) {
        return false;
    }

    public void extractBreakPoints(List breakPointList) {
    }

    public void focusLost() {
    }

    public void goToStart() {
    }

    public void marksChanged() {
    }

    public void removeDependableAction(Action action) {
    }

    public void removeUndoableEditListener(UndoableEditListener listener) {
    }

    public void runActionByName(String name) {
    }

    public void select(int start, int end) {
    }

    public void selectLine(int line) {
    }

    public void touch() {
    }

    public void updateCompilationStatus() {
    }

    public void setSelectionProvider(SelectionProvider selectionProvider) {
    }
}

