/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import oracle.bpm.collections.CollectionUtils;
import oracle.bpm.collections.Predicate;
import oracle.bpm.collections.Sequence;
import oracle.bpm.designer.ProjectObjectEditorPanel;
import oracle.bpm.designer.conversation.ProjectObjectBrowser;
import oracle.bpm.designer.conversation.ReferenceComboBox;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.event.ModificationEvent;
import oracle.bpm.event.ModificationListener;
import oracle.bpm.project.compile.msg.ProjectCompileMsg;
import oracle.bpm.project.model.ProjectObject;
import oracle.bpm.project.model.ProjectObjectContainer;
import oracle.bpm.project.model.catalog.CatalogMember;
import oracle.bpm.project.model.catalog.CatalogObject;
import oracle.bpm.project.model.catalog.InterfaceObject;
import oracle.bpm.project.model.exception.ProjectException;
import oracle.bpm.project.model.processes.FlowNode;
import oracle.bpm.project.model.processes.ParticipantEnabled;
import oracle.bpm.project.view.filter.ConfigurableProjectFilter;
import oracle.bpm.project.view.filter.DefaultProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilter;
import oracle.bpm.project.view.filter.ProjectFilters;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticipantEditorPanel
extends ProjectObjectEditorPanel<ParticipantEnabled> {
    protected ReferenceComboBox<CatalogMember> operationComboBox;
    protected ProjectObjectBrowser<CatalogObject> serviceBrowser;
    private CatalogMember fixedOperation;

    public ParticipantEditorPanel(@NotNull UiContainer parent, @NotNull ParticipantEnabled projectObject, @NotNull CatalogMember fixedOperation) {
        this(parent, projectObject, fixedOperation.getParentObject());
        this.fixedOperation = fixedOperation;
        this.operationComboBox.setValue(fixedOperation);
    }

    public ParticipantEditorPanel(@NotNull UiContainer parent, @NotNull ParticipantEnabled projectObject, CatalogObject fixedService) {
        this(parent, projectObject, ParticipantEditorPanel.createFixedServiceFilter(fixedService));
        this.serviceBrowser.setValue(fixedService);
    }

    public ParticipantEditorPanel(@NotNull UiContainer parent, @NotNull ParticipantEnabled projectObject, @NotNull ServiceEditorServiceType serviceType, @NotNull ServiceEditorSynchronicityType syncType, @NotNull ServiceEditorInterfaceType interfaceType) {
        this(parent, projectObject, ParticipantEditorPanel.createDyncamicServiceFilter(serviceType, syncType, interfaceType));
    }

    private ParticipantEditorPanel(@NotNull UiContainer parent, @NotNull ParticipantEnabled projectObject, ProjectFilter serviceFilter) {
        super(parent, projectObject);
        this.init(serviceFilter);
    }

    @Override
    public void objectToEditor(ParticipantEnabled projectObject) {
        ParticipantEnabled participantEnabled = (ParticipantEnabled)this.getProjectObject();
        this.serviceBrowser.setValue(participantEnabled.getParticipant());
        this.operationComboBox.setSelectedItem(participantEnabled.getOperation());
    }

    @Override
    public ParticipantEnabled editorToObject() throws ProjectException {
        ParticipantEnabled participantEnabled = (ParticipantEnabled)this.getProjectObject();
        participantEnabled.setOperation((CatalogMember)this.operationComboBox.getSelectedItem());
        return participantEnabled;
    }

    @Override
    public void validatePanel() throws ProjectException {
        Object projectObject = this.getProjectObject();
        String label = ((FlowNode)projectObject).getDefaultLabel();
        if (this.serviceBrowser.getValue() != null && !this.serviceBrowser.isValidSelection()) {
            throw new ProjectException(projectObject, ProjectCompileMsg.SERVICE_INVALID((String)label));
        }
        if (this.operationComboBox.getSelectedItem() == null && !this.operationComboBox.isValidSelection()) {
            throw new ProjectException(projectObject, ProjectCompileMsg.OPERATION_INVALID((String)label));
        }
    }

    private static ProjectFilter createDyncamicServiceFilter(final @NotNull ServiceEditorServiceType serviceType, final @NotNull ServiceEditorSynchronicityType syncType, @NotNull ServiceEditorInterfaceType interfaceType) {
        ProjectFilter serviceFilter;
        switch (interfaceType) {
            case SERVICE: {
                serviceFilter = ProjectFilters.SERVICE_OBJECTS;
                break;
            }
            case REFERENCE: {
                serviceFilter = ProjectFilters.REFERENCE_OBJECTS;
                break;
            }
            default: {
                serviceFilter = ProjectFilters.INTERFACE_OBJECTS;
            }
        }
        ConfigurableProjectFilter callbackSyncFilter = new ConfigurableProjectFilter(serviceFilter);
        callbackSyncFilter.addIncluded((Predicate)new Predicate<ProjectObject>(){

            @Override
            public boolean check(@Nullable ProjectObject value) {
                InterfaceObject service = (InterfaceObject)value;
                return value != null && (serviceType == ServiceEditorServiceType.ALL || serviceType == ServiceEditorServiceType.INVOKE && !service.isCallback() || serviceType == ServiceEditorServiceType.CALLBACK && service.isCallback()) && (syncType == ServiceEditorSynchronicityType.ALL || syncType == ServiceEditorSynchronicityType.SYNCHRONOUS && service.isSync() || syncType == ServiceEditorSynchronicityType.ASYNCHRONOUS && !service.isSync());
            }
        });
        return callbackSyncFilter;
    }

    private static ProjectFilter createFixedServiceFilter(CatalogObject fixedService) {
        return new FixedServiceFilter((ProjectObject)fixedService);
    }

    private void init(@NotNull ProjectFilter serviceFilter) {
        this.setLayout((Layout)new MigLayout("ins 0, gap 0, fillx"));
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.NAME));
        this.serviceBrowser = this.createServiceBrowser((UiContainer)this, serviceFilter);
        this.add((UiComponent)this.serviceBrowser, "growx, gapx 5, wrap");
        this.add((UiComponent)Label.create((UiContainer)this, (Msg)DesignerMsg.OPERATION));
        this.operationComboBox = this.createOperationComboBox((UiContainer)this);
        this.add((UiComponent)this.operationComboBox, "growx, gapx 5, gapy 5");
    }

    private void reloadOperationComboBox() {
        this.operationComboBox.removeAllItems();
        CatalogObject selectedService = this.serviceBrowser.getValue();
        if (selectedService != null) {
            if (this.fixedOperation != null) {
                if (selectedService == this.fixedOperation.getParentObject()) {
                    this.operationComboBox.addItem(this.fixedOperation);
                }
            } else {
                for (CatalogMember operation : selectedService.getChildrenByType(CatalogMember.class)) {
                    this.operationComboBox.addItem(operation);
                }
            }
        }
    }

    private ProjectObjectBrowser<CatalogObject> createServiceBrowser(@NotNull UiContainer container, @NotNull ProjectFilter filter) {
        ProjectObjectBrowser<CatalogObject> result = new ProjectObjectBrowser<CatalogObject>(container, filter, (ProjectObjectContainer)((ParticipantEnabled)this.getProjectObject()).getProject().getCatalogRoot());
        LabelProvider.Default<CatalogObject> labelProvider = new LabelProvider.Default<CatalogObject>(){

            public String getText(CatalogObject element) {
                return element.getName();
            }
        };
        result.setLabelProvider((LabelProvider<CatalogObject>)labelProvider);
        result.addModificationListener(new ModificationListener(){

            public void objectModified(ModificationEvent modificationEvent) {
                ParticipantEditorPanel.this.reloadOperationComboBox();
            }
        });
        return result;
    }

    private ReferenceComboBox<CatalogMember> createOperationComboBox(@NotNull UiContainer container) {
        ReferenceComboBox<CatalogMember> result = new ReferenceComboBox<CatalogMember>(container);
        LabelProvider.Default<CatalogMember> labelProvider = new LabelProvider.Default<CatalogMember>(){

            public String getText(CatalogMember element) {
                return element.getName();
            }
        };
        result.setLabelProvider((LabelProvider)labelProvider);
        return result;
    }

    private static class FixedServiceFilter
    extends DefaultProjectFilter
    implements ProjectFilter {
        private ProjectObject fixedService;

        private FixedServiceFilter(@NotNull ProjectObject fixedService) {
            this.fixedService = fixedService;
        }

        @NotNull
        public Sequence<? extends ProjectObject> getChildren(ProjectObjectContainer object) {
            ArrayList<ProjectObject> result = new ArrayList<ProjectObject>();
            if (object != this.fixedService) {
                try {
                    result.add(this.fixedService);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return CollectionUtils.asSequence(result);
        }
    }

    public static enum ServiceEditorInterfaceType {
        ALL,
        SERVICE,
        REFERENCE;

    }

    public static enum ServiceEditorSynchronicityType {
        ALL,
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }

    public static enum ServiceEditorServiceType {
        ALL,
        INVOKE,
        CALLBACK;

    }
}

