/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.designer;

import java.util.ArrayList;
import javax.swing.ListModel;
import oracle.bpm.designer.SingleProcessCanvas;
import oracle.bpm.designer.action.OpenObjectAction;
import oracle.bpm.designer.msg.DesignerMsg;
import oracle.bpm.lib.msg.LibMsg;
import oracle.bpm.processmodel.SchemaType;
import oracle.bpm.project.model.Project;
import oracle.bpm.project.model.processes.Process;
import oracle.bpm.project.model.util.ModelUtils;
import oracle.bpm.resources.Msg;
import oracle.bpm.ui.BorderPanel;
import oracle.bpm.ui.Label;
import oracle.bpm.ui.LabelProvider;
import oracle.bpm.ui.List;
import oracle.bpm.ui.ListSelectionMode;
import oracle.bpm.ui.OkCancelDialog;
import oracle.bpm.ui.Panel;
import oracle.bpm.ui.ScrollPane;
import oracle.bpm.ui.ScrollPolicy;
import oracle.bpm.ui.SplitPane;
import oracle.bpm.ui.UiComponent;
import oracle.bpm.ui.UiContainer;
import oracle.bpm.ui.UiWindow;
import oracle.bpm.ui.event.DocumentEvent;
import oracle.bpm.ui.event.DocumentListener;
import oracle.bpm.ui.event.ListSelectionEvent;
import oracle.bpm.ui.event.ListSelectionListener;
import oracle.bpm.ui.event.MouseEvent;
import oracle.bpm.ui.event.MouseListener;
import oracle.bpm.ui.layout.Layout;
import oracle.bpm.ui.layout.border.BorderLayout;
import oracle.bpm.ui.text.TextField;

public class OpenProcessDialog
extends OkCancelDialog {
    private boolean open = true;
    private List<Process> processesList;
    private TextField processNameField;
    private Project project;
    private SchemaType schemaType = null;

    public OpenProcessDialog(UiWindow owner, Project project) {
        this(owner, project, true, null, false);
    }

    public OpenProcessDialog(UiWindow owner, Project project, boolean open, SchemaType schemaType, boolean multipleSelection) {
        super(owner, true);
        this.project = project;
        this.open = open;
        this.schemaType = schemaType;
        this.init(multipleSelection);
        this.setSize(550, 400);
        this.setLocationRelativeTo((UiComponent)this.getParent());
    }

    public Process[] getSelectedProcesses() {
        int[] indices = this.processesList.getSelectedIndices();
        Process[] processes = new Process[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            int indice = indices[i];
            processes[i] = (Process)this.processesList.getModel().getElementAt(indice);
        }
        return processes;
    }

    public void ok() {
        if (this.open) {
            Process[] processes;
            for (Process process : processes = this.getSelectedProcesses()) {
                new OpenObjectAction(process).doIt();
            }
        }
        this.setUserAccepted(true);
        this.close();
    }

    private void incrSearch(String text) {
        Process fuegoProcess;
        int i;
        for (i = 0; i < this.processesList.getModel().getSize(); ++i) {
            fuegoProcess = (Process)this.processesList.getModel().getElementAt(i);
            if (!ModelUtils.getModelTitle((Process)fuegoProcess).toLowerCase().equals(text.toLowerCase())) continue;
            this.processesList.setSelectedIndex(i);
            this.processesList.ensureIndexIsVisible(i);
            return;
        }
        for (i = 0; i < this.processesList.getModel().getSize(); ++i) {
            fuegoProcess = (Process)this.processesList.getModel().getElementAt(i);
            if (!ModelUtils.getModelTitle((Process)fuegoProcess).toLowerCase().startsWith(text.toLowerCase())) continue;
            this.processesList.setSelectedIndex(i);
            this.processesList.ensureIndexIsVisible(i);
            return;
        }
        this.processesList.setSelectedIndex(-1);
    }

    private void init(boolean multipleSelection) {
        String text = this.schemaType == null ? DesignerMsg.OPEN_PROJECT_PROCESS.getString() : this.schemaType.getString();
        this.setTitle(LibMsg.OPEN.getString() + " " + text);
        BorderPanel mainPanel = new BorderPanel(this.getContentPane());
        Panel centerPanel = new Panel((UiContainer)mainPanel);
        Panel northPanel = new Panel((UiContainer)mainPanel);
        SplitPane splitPane = new SplitPane((UiContainer)centerPanel, 1);
        Panel panel = new Panel((UiContainer)splitPane);
        panel.setLayout((Layout)new BorderLayout());
        splitPane.setLeftComponent((UiComponent)panel);
        this.processesList = List.create((UiContainer)panel, new ArrayList(this.project.getProcesses()), (ListSelectionMode)(multipleSelection ? ListSelectionMode.MULTIPLE_INTERVAL_SELECTION : ListSelectionMode.SINGLE_SELECTION));
        LabelProvider.Default<Process> labelProvider = new LabelProvider.Default<Process>(){

            public String getText(Process model) {
                return ModelUtils.getModelTitle((Process)model);
            }
        };
        this.processesList.setLabelProvider((LabelProvider)labelProvider);
        panel.add(this.processesList, (Object)"Center");
        ScrollPane jsPane = new ScrollPane((UiContainer)splitPane, ScrollPolicy.AS_NEEDED, ScrollPolicy.AS_NEEDED);
        splitPane.setRightComponent((UiComponent)jsPane);
        splitPane.setDividerLocation(220);
        final SingleProcessCanvas singleProcessImagePanel = new SingleProcessCanvas((UiContainer)jsPane);
        jsPane.setView((UiComponent)singleProcessImagePanel);
        singleProcessImagePanel.setProcessToRender(null);
        this.processesList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                Process fuegoProcess = (Process)OpenProcessDialog.this.processesList.getSelectedValue();
                if (!OpenProcessDialog.this.processesList.getSelectedValues().isEmpty()) {
                    singleProcessImagePanel.setProcessToRender(null);
                    OpenProcessDialog.this.repaint();
                }
                if (fuegoProcess != null && singleProcessImagePanel != null) {
                    singleProcessImagePanel.setProcessToRender(fuegoProcess);
                    OpenProcessDialog.this.repaint();
                }
            }
        });
        this.processesList.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                int index;
                if (e.getClickCount() == 2 && (index = OpenProcessDialog.this.processesList.getSelectedIndex()) != -1) {
                    OpenProcessDialog.this.ok();
                }
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseDoubleClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
        northPanel.setLayout((Layout)new BorderLayout());
        if (this.schemaType == null) {
            northPanel.add((UiComponent)Label.create((UiContainer)northPanel, (Msg)DesignerMsg.PROCESS_NAME), (Object)"West");
        } else {
            northPanel.add((UiComponent)Label.create((UiContainer)northPanel, (Msg)this.schemaType.getMsg()), (Object)"West");
        }
        this.processNameField = new TextField((UiContainer)northPanel, 30);
        northPanel.add((UiComponent)this.processNameField, (Object)"Center");
        if (this.open) {
            // empty if block
        }
        centerPanel.setLayout((Layout)new BorderLayout());
        centerPanel.add((UiComponent)splitPane, (Object)"Center");
        mainPanel.setLayout((Layout)new BorderLayout());
        mainPanel.add((UiComponent)centerPanel, (Object)"Center");
        mainPanel.add((UiComponent)northPanel, (Object)"North");
        this.getContentPane().add((UiComponent)mainPanel, (Object)"Center");
        this.processNameField.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                OpenProcessDialog.this.incrSearch(OpenProcessDialog.this.processNameField.getText());
            }

            public void removeUpdate(DocumentEvent e) {
                OpenProcessDialog.this.incrSearch(OpenProcessDialog.this.processNameField.getText());
            }

            public void changedUpdate(DocumentEvent e) {
                OpenProcessDialog.this.incrSearch(OpenProcessDialog.this.processNameField.getText());
            }
        });
        ListModel model = this.processesList.getModel();
        if (model != null && model.getSize() > 0) {
            this.processesList.setSelectedIndex(0);
        }
        this.pack();
        this.centerOnScreen();
        this.processNameField.requestFocus();
    }
}

